/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.rules;

import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.problems.NonExistentTagProblem;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllTagsExistRule
extends AbstractBuildRule {
    public static final String ID = AllTagsExistRule.class.getCanonicalName();

    public AllTagsExistRule() {
        super(TagRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        ITagset tagset = TagRep.getTagset(model);
        LinkedList<IDesc> descsWithMissingTags = new LinkedList<IDesc>();
        if (tagset == null) {
            descsWithMissingTags.addAll((Collection<IDesc>)model.getData().getDescriptions(TagRep.getInstance()));
        } else {
            for (IDesc d : model.getData().getDescriptions(TagRep.getInstance())) {
                ITagData tagData = (ITagData)d.getData();
                if (tagset.getTag(tagData.getTagID()) != null) continue;
                descsWithMissingTags.add(d);
            }
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : descsWithMissingTags) {
            result.add((Object)new NonExistentTagProblem(d, this.getID()));
        }
        return result;
    }
}

