/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.util;

import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParsingUtils
implements IUtilityClass {
    private ParsingUtils() {
    }

    protected static int consume(String sub, int start, String string) {
        int idx = 0;
        int i = start;
        while (i < string.length() && idx < sub.length()) {
            idx = sub.charAt(idx) == string.charAt(i) ? ++idx : 0;
            ++i;
        }
        return i;
    }

    public static SortedSet<IDesc> extractContext(IHasPosition p, int numBefore, int numAfter, IStoryData data) {
        IDesc desc;
        IDescSet sentDescs = data.getDescriptions(SentenceRep.getInstance());
        TreeSet<IDesc> descs = new TreeSet<IDesc>();
        descs.addAll((Collection<IDesc>)sentDescs.openSet(p));
        int i = 0;
        while (i < numBefore) {
            desc = (IDesc)PositionUtils.getPrevious((IHasPosition)((IDesc)descs.first()), (IHasPositionSet)sentDescs);
            if (desc != null) {
                descs.add(desc);
            }
            ++i;
        }
        i = 0;
        while (i < numAfter) {
            desc = (IDesc)PositionUtils.getNext((IHasPosition)((IDesc)descs.last()), (IHasPositionSet)sentDescs);
            if (desc != null) {
                descs.add(desc);
            }
            ++i;
        }
        return descs;
    }

    public static IDesc getSelectedTag(IStoryEditor editor) {
        IHasPosition selection = editor.getSelectedRange();
        return selection == null ? null : ParsingUtils.getTag(selection, editor.getStoryModel().getData());
    }

    public static IDesc getTag(IHasPosition p, IStoryData data) {
        if (p == null || data == null || !data.supports(POSRep.getInstance())) {
            return null;
        }
        IDescSet tags = data.getDescriptions(POSRep.getInstance());
        IDescSet subset = tags.openSet(p);
        subset = subset.isEmpty() ? tags.closedSet(p) : subset;
        return subset.size() == 1 ? (IDesc)subset.first() : null;
    }

    public static IDesc getSelectedToken(IStoryEditor editor) {
        IHasPosition selection = editor.getSelectedRange();
        return selection == null ? null : ParsingUtils.getToken(selection, editor.getStoryModel().getData());
    }

    public static IDesc getToken(IHasPosition p, IStoryData data) {
        if (p == null || data == null || !data.supports(TokenRep.getInstance())) {
            return null;
        }
        IDescSet tokens = data.getDescriptions(TokenRep.getInstance());
        IDescSet subset = tokens.openSet(p);
        subset = subset.isEmpty() ? tokens.closedSet(p) : subset;
        return subset.size() == 1 ? (IDesc)subset.first() : null;
    }

    public static IDescSet getSelectedTokens(IStoryEditor editor) {
        if (editor == null) {
            return null;
        }
        IHasPosition selection = editor.getSelectedRange();
        if (selection == null) {
            return null;
        }
        return ParsingUtils.getTokens(selection, editor.getStoryModel().getData());
    }

    public static IHasPosition getTokenRange(IHasPosition p, IStoryData data) {
        IDescSet tokens = ParsingUtils.getTokens(p, data);
        return tokens.isEmpty() ? null : new SimplePosition((IHasPosition)tokens);
    }

    public static IDescSet getTokens(IHasPosition p, IStoryData data) {
        if (p == null || data == null || !data.supports(TokenRep.getInstance())) {
            return null;
        }
        return DescUtils.getDescriptions((IHasPosition)p, (IDescSet)data.getDescriptions(TokenRep.getInstance()));
    }

    public static IDescSet getTokens(IHasPosition p, IDescSet tokens) {
        if (p == null || tokens == null || !TokenRep.getInstance().isType((IHasRep)tokens)) {
            return null;
        }
        if (tokens.isEmpty()) {
            return tokens;
        }
        IDescSet subset = tokens.openSet(p);
        return subset.isEmpty() ? tokens.closedSet(p) : subset;
    }

    public static String getFirstWords(IHasPosition p, IStoryData data, int num) {
        IDescSet tokens = ParsingUtils.getTokens(p, data);
        if (tokens == null) {
            return null;
        }
        Iterator itr = tokens.iterator();
        int i = 0;
        while (i < num) {
            if (!itr.hasNext()) break;
            itr.next();
            ++i;
        }
        tokens = itr.hasNext() ? tokens.headSet((IDesc)itr.next()) : tokens;
        return String.valueOf(TextRep.getPrettyText((IHasPosition)tokens, (IStoryData)data)) + "...";
    }
}

