/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search.federated;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.search.federated.LocalHelpScope;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.search.ISearchEngine2;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.search.LuceneSearchParticipant;

public class LocalHelp
implements ISearchEngine2 {
    private static final int MAX_HITS = 500;

    public void run(String query, ISearchScope scope, ISearchEngineResultCollector collector, IProgressMonitor monitor) throws CoreException {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.setSearchWord(query);
        WorkingSet[] workingSets = null;
        LocalHelpScope localScope = (LocalHelpScope)scope;
        if (localScope.getWorkingSet() != null) {
            workingSets = new WorkingSet[]{localScope.getWorkingSet()};
        }
        SearchResults localResults = new SearchResults(workingSets, 500, Platform.getNL());
        try {
            Job.getJobManager().join((Object)"org.eclipse.help.base.indexer", monitor);
        }
        catch (InterruptedException interruptedException) {}
        BaseHelpSystem.getSearchManager().search(searchQuery, localResults, monitor);
        this.postResults(localResults, collector, localScope.getCapabilityFiltered());
    }

    private void postResults(SearchResults results, ISearchEngineResultCollector collector, boolean activityFiltering) {
        ISearchEngineResult[] searchHits = results.getSearchHits();
        if (!activityFiltering) {
            collector.accept(searchHits);
            return;
        }
        ArrayList<ISearchEngineResult> enabledHits = new ArrayList<ISearchEngineResult>();
        int i = 0;
        while (i < searchHits.length) {
            ISearchEngineResult hit = searchHits[i];
            if (((SearchHit)hit).getParticipantId() != null) {
                if (HelpBasePlugin.getActivitySupport().isEnabled(((SearchHit)hit).getHref())) {
                    enabledHits.add(hit);
                }
            } else if (HelpBasePlugin.getActivitySupport().isEnabledTopic(((SearchHit)hit).getHref(), Platform.getNL())) {
                enabledHits.add(hit);
            }
            ++i;
        }
        collector.accept(enabledHits.toArray(new SearchHit[enabledHits.size()]));
    }

    public String toAbsoluteHref(String href, boolean frames) {
        return null;
    }

    public boolean open(String id) {
        int sep = id.indexOf(47);
        if (sep == -1) {
            return false;
        }
        String participantId = id.substring(0, sep);
        id = id.substring(sep + 1);
        LuceneSearchParticipant participant = BaseHelpSystem.getLocalSearchManager().getGlobalParticipant(participantId);
        if (participant == null) {
            return false;
        }
        try {
            return participant.open(id);
        }
        catch (Throwable t) {
            HelpBasePlugin.logError("Error occured in search participant trying to open document with id: " + id + ", participant: " + participant.getClass().getName(), t);
            return false;
        }
    }
}

