/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.semantics.core.rep.context.model.ContextRelArgModel;
import edu.mit.semantics.core.rep.context.model.ContextRelationModel;
import edu.mit.semantics.core.rep.context.model.IContextRelArgModel;
import edu.mit.semantics.core.rep.context.model.IContextRelationModel;
import edu.mit.semantics.ui.controllers.ContextArgController;
import edu.mit.semantics.ui.controllers.IContextArgController;
import edu.mit.semantics.ui.controllers.IContextRelationController;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;

public class ContextRelationController
implements IContextRelationController {
    private final IStoryEditor editor;
    private final IContextRelationModel model;
    private final IContextArgController argController;
    private final ISegmentSetController signalController;

    public ContextRelationController(String sigAnnoID, String argAnnoID, IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.model = new ContextRelationModel((IStoryModel)editor.getStoryModel());
        this.signalController = new SegmentSetController(this.model.getSignalModel(), editor, sigAnnoID);
        this.argController = new ContextArgController(argAnnoID, editor);
    }

    public IContextRelationModel getModel() {
        return this.model;
    }

    public ISegmentSetController getSignalController() {
        return this.signalController;
    }

    public IContextArgController getArgController() {
        return this.argController;
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void addArgument() {
        boolean create;
        IContextRelArgModel widgetModel = (IContextRelArgModel)this.argController.getDescModel();
        if (widgetModel.getMessageType() == 3) {
            return;
        }
        ContextRelArgModel argModel = null;
        if (widgetModel.getLoaded() != null) {
            for (IContextRelArgModel arg : this.model.getArguments()) {
                if (widgetModel.getLoaded() != arg) continue;
                argModel = arg;
                break;
            }
        }
        boolean bl = create = argModel == null;
        if (create) {
            argModel = new ContextRelArgModel(this.model.getStoryModel());
        }
        argModel.setRole(widgetModel.getRole());
        argModel.setDesc(widgetModel.getFiller());
        argModel.setDepth(widgetModel.getDepth());
        argModel.setExclusionGroup(widgetModel.getExclusionGroup());
        if (create) {
            this.model.getArguments().add(argModel);
        }
        widgetModel.clear();
    }

    public void removeArgument(IContextRelArgModel d) {
        this.model.getArguments().remove(d);
    }

    public void commit() {
        IContextRelation data = this.getModel().create();
        Timing timing = new Timing(this.model.getStart(), "user");
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)ContextRelationRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)this.model.getLoaded());
        this.clear();
    }

    public void clear() {
        this.getModel().clear();
        this.argController.clear();
        this.signalController.clear();
    }

    public void load(IDesc desc) {
        this.getModel().load(desc);
    }

    public void dispose() {
        this.argController.dispose();
        this.signalController.dispose();
    }
}

