/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.jpropbank.IArg;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.parsing.core.rep.stem.algorithm.SimpleStemmer;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.SemArg;
import edu.mit.semantics.core.rep.semrole.SemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.core.rep.semrole.model.ISemArgModel;
import edu.mit.semantics.core.rep.semrole.model.ISemRoleModel;
import edu.mit.semantics.core.rep.semrole.model.SemArgModel;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.semantics.ui.controllers.ArgController;
import edu.mit.semantics.ui.controllers.IArgController;
import edu.mit.semantics.ui.controllers.ISemRoleController;
import edu.mit.semantics.ui.controllers.PredicateController;
import edu.mit.semantics.ui.dialogs.RolesetSelectionDialog;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.descriptor.ICreatableDescriptor;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemRoleController<M extends ISemRoleModel>
extends PredicateController<M>
implements ISemRoleController<M> {
    private final IArgController argController;
    private ActionGroup undoRedoActionGroup;
    private IStemmer controllerStemmer;
    private static final Set<ITag> allTags;

    static {
        HashSet<PennTag> tags = new HashSet<PennTag>(4);
        tags.add(PennTag.NN);
        tags.add(PennTag.VB);
        tags.add(PennTag.RB);
        tags.add(PennTag.JJ);
        allTags = Collections.unmodifiableSet(tags);
    }

    public SemRoleController(M model, String predAnnoID, String argAnnoID, IStoryEditor editor) {
        super(model, predAnnoID, editor);
        this.argController = new ArgController((ISemArgModel)new SemArgModel((IStoryModel)editor.getStoryModel()), argAnnoID, editor);
        ((ISemRoleModel)this.getDescModel()).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                IArg editTarget = SemRoleController.this.argController.getArgModel().getLoaded();
                if (editTarget == null) {
                    return;
                }
                if (((ISemRoleModel)SemRoleController.this.getDescModel()).getArgumentModels().contains(editTarget)) {
                    return;
                }
                SemRoleController.this.argController.clear();
            }
        });
    }

    public IStemmer getStemmer() {
        List ds;
        if (this.controllerStemmer != null) {
            return this.controllerStemmer;
        }
        ICreatableDescriptor d = (ICreatableDescriptor)ParsingPlugin.getDefault().getStemmerManager().getDescriptor("edu.mit.wordnet.stemmer.wordnet");
        this.controllerStemmer = d == null ? ((ds = ParsingPlugin.getDefault().getStemmerManager().getDescriptors()).isEmpty() ? new SimpleStemmer() : (IStemmer)((ICreatableDescriptor)ds.get(0)).create()) : (IStemmer)d.create();
        this.controllerStemmer.init();
        return this.controllerStemmer;
    }

    @Override
    public IArgController getArgController() {
        return this.argController;
    }

    @Override
    public void commit() {
        ISemRoleModel model = (ISemRoleModel)this.getDescModel();
        Timing timing = new Timing(model.getStart(), "user");
        List oldArgs = model.getArguments();
        ArrayList<SemArg> newArgs = new ArrayList<SemArg>(oldArgs.size());
        for (ISemArg oldArg : oldArgs) {
            List loc = oldArg.getLocation();
            newArgs.add(new SemArg(model.getRoleset(), oldArg.getLabel(), oldArg.getFeature(), loc));
        }
        SemRole data = new SemRole(model.getRoleset(), model.getParse(), model.getTerminal(), (IPredicateFeatures)model, newArgs, false);
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)SemRoleRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }

    protected void setDesc(IDesc desc) {
        super.setDesc(desc);
        this.updatePossibleRolesets();
    }

    protected void updatePossibleRolesets() {
        IDescSet stemDescs;
        IDesc desc = ((ISemRoleModel)this.getDescModel()).getDesc();
        if (desc == null) {
            ((ISemRoleModel)this.getDescModel()).setPossibleRoleSets(null);
            return;
        }
        List<String> stems = null;
        if (this.getStoryEditor().getStoryModel().supports(StemRep.getInstance()) && !(stemDescs = this.getStoryEditor().getStoryModel().getData().getDescriptions(StemRep.getInstance()).closedSet((IHasPosition)desc)).isEmpty()) {
            stems = new ArrayList<String>(stemDescs.size());
            for (IDesc stemDesc : stemDescs) {
                IStem stem = (IStem)stemDesc.getData();
                stems.add(stem.getStem());
            }
        }
        if (stems == null) {
            IDescSet posDescs = this.getStoryEditor().getStoryModel().getData().getDescriptions(POSRep.getInstance()).closedSet((IHasPosition)desc);
            HashSet<ITag> tags = new HashSet<ITag>();
            for (IDesc posDesc : posDescs) {
                IPosTag pos = (IPosTag)posDesc.getData();
                tags.add(pos.getTag());
            }
            if (tags.isEmpty()) {
                tags.addAll(allTags);
            }
            IToken token = (IToken)desc.getData();
            stems = new LinkedList<String>();
            IStemmer stemmer = this.getStemmer();
            for (ITag tag : tags) {
                SortedSet results = stemmer.getStems(token.getSurface(), tag);
                if (results == null) continue;
                stems.addAll(results);
            }
        }
        IToken token = (IToken)desc.getData();
        if (stems == null || stems.isEmpty()) {
            stems = Collections.singletonList(token.getSurface().toLowerCase());
        }
        LinkedList<IRoleset> rolesets = new LinkedList<IRoleset>();
        for (String stem : stems) {
            List p = (List)SemanticsPlugin.getDefault().getFrameManager().getPredicates().get(stem);
            if (p == null) continue;
            rolesets.addAll(p);
        }
        if (token.getToken().equals("``")) {
            rolesets.add((IRoleset)SemanticsPlugin.getDefault().getFrameManager().getRoleSets().get("say.01"));
        }
        if (this.getArgController().getArgModel().getRoleset() != null) {
            rolesets.add(this.getArgController().getArgModel().getRoleset());
        }
        ((ISemRoleModel)this.getDescModel()).setPossibleRoleSets(rolesets);
    }

    @Override
    public void clear() {
        this.argController.clear();
        super.clear();
    }

    @Override
    public void load(IDesc desc) {
        boolean acceptLoad;
        boolean bl = acceptLoad = ((ISemRoleModel)this.getDescModel()).isCleared() ? true : SemRoleController.confirmLoad(this.editor.getSite().getShell());
        if (acceptLoad) {
            this.argController.clear();
            ((ISemRoleModel)this.getDescModel()).load(desc);
            this.updatePossibleRolesets();
        }
    }

    @Override
    public ActionGroup getUndoRedoActionGroup() {
        if (this.undoRedoActionGroup == null) {
            this.undoRedoActionGroup = new StoryEditorUndoRedoActionGroup(this.editor);
        }
        return this.undoRedoActionGroup;
    }

    public static boolean confirmLoad(Shell shell) {
        String key = "DoNotPromptToAcceptWhenOverwritingSemRoleModelState";
        IPreferenceStore prefs = SemanticsUIPlugin.getDefault().getPreferenceStore();
        String value = prefs.getString(key);
        if ("always".equals(value)) {
            return true;
        }
        String title = "Confirm Edit";
        String message = "If you edit this semantic role you will loose your current work in the creator. Do you want to continue?";
        String toggleMessage = "Do not prompt me when this happens; always discard current work";
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)title, (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)prefs, (String)key);
        return dialog.getReturnCode() == 0;
    }

    public void setRoleSet(ISelection sel) {
        IRoleset roleset = (IRoleset)SelectionUtils.extractSingle((ISelection)sel, IRoleset.class);
        this.setRoleSet(roleset);
    }

    @Override
    public void setRoleSet(IRoleset roleset) {
        this.getArgController().setRoleSet(roleset);
        Set<IRoleset> rs = ((ISemRoleModel)this.getDescModel()).getPossibleRoleSets();
        if (roleset != null && !rs.contains(roleset)) {
            rs = new HashSet(rs);
            rs.add(roleset);
            ((ISemRoleModel)this.getDescModel()).setPossibleRoleSets(rs);
        }
        ((ISemRoleModel)this.getDescModel()).setRoleSet(roleset);
    }

    @Override
    public void createArgument() {
        ISemArgModel arg;
        ISemArgModel argModel = this.argController.getArgModel();
        IArg editTarget = argModel.getLoaded();
        ArrayList segments = new ArrayList(argModel.getSegments());
        String label = argModel.getLabel();
        String feature = argModel.getFeature();
        IRoleset roles = argModel.getRoleset();
        argModel.clear();
        if (editTarget == null) {
            arg = new SemArgModel(((ISemRoleModel)this.getDescModel()).getStoryModel());
        } else {
            arg = (ISemArgModel)editTarget;
            ((ISemRoleModel)this.getDescModel()).getArgumentModels().remove(arg);
        }
        arg.setSegments(segments);
        arg.setLabel(label);
        arg.setFeature(feature);
        arg.setRoleset(roles);
        ((ISemRoleModel)this.getDescModel()).getArgumentModels().add(arg);
    }

    @Override
    public void chooseArbitraryRoleset() {
        IRoleset selection = RolesetSelectionDialog.selectRoleset(this.getStoryEditor().getSite().getShell(), ((ISemRoleModel)this.getDescModel()).getRoleset());
        if (selection != null) {
            this.setRoleSet(selection);
        }
    }
}

