/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.semantics.core.rep.timex3.model.ITimex3Model;
import edu.mit.semantics.core.rep.timex3.model.Timex3Model;
import edu.mit.semantics.ui.controllers.ITimex3Controller;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;

public class Timex3Controller
extends SegmentSetController
implements ITimex3Controller {
    private final ISegmentSetController quantController;
    private final ISegmentSetController freqController;

    public Timex3Controller(String expAnnoID, IStoryEditor editor, String quantAnnoID, String freqAnnoID) {
        super((ISegmentSetModel)new Timex3Model((IStoryModel)editor.getStoryModel()), editor, expAnnoID);
        this.quantController = new SegmentSetController(this.getModel().getQuantificationModel(), editor, quantAnnoID);
        this.freqController = new SegmentSetController(this.getModel().getFrequencyModel(), editor, freqAnnoID);
    }

    public ITimex3Model getModel() {
        return (ITimex3Model)super.getModel();
    }

    public void setType(ITimex3.Type type) {
        this.getModel().setType(type);
    }

    public void setModification(ITimex3.Mod mod) {
        this.getModel().setModification(mod);
    }

    public void setFunction(ITimex3.Function func) {
        this.getModel().setFunctionInDoc(func);
    }

    public void setValue(String value) {
        this.getModel().setValue(value);
    }

    public void setTemporalFunction(boolean val) {
        this.getModel().setTemporalFunction(val);
    }

    public void load(IDesc timex) {
        this.getModel().load(timex);
    }

    public void commit() {
        ITimex3Model model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing timing = new Timing(model.getStart(), "user");
        ITimex3 data = model.toTimex3();
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)Timex3Rep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }

    public ISegmentSetController getFreqController() {
        return this.freqController;
    }

    public ISegmentSetController getQuantController() {
        return this.quantController;
    }
}

