/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.dialogs;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.semantics.ui.content.EventContentProvider;
import edu.mit.semantics.ui.label.EventLabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.position.PositionComparator;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.util.IHasDisplayText;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class EventSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = EventSelectionDialog.class.getCanonicalName();
    private IStoryEditor editor;
    private IStructuredContentProvider dialogCP;

    public EventSelectionDialog(Shell parent, IStoryEditor editor) {
        super(parent);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.dialogCP = new EventContentProvider(editor);
        this.setListLabelProvider((ILabelProvider)new EventLabelProvider(editor));
        this.setInitialPattern("?");
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new EventFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider targetCP, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        Object[] elements = this.dialogCP.getElements((Object)this.editor.getStoryModel());
        pm.beginTask("Searching...", elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            targetCP.add(element, itemsFilter);
            pm.worked(1);
            ++n2;
        }
        pm.done();
    }

    public String getElementName(Object item) {
        IDesc d = (IDesc)item;
        IEvent e = (IEvent)d.getData();
        return e.getEventTokens().getDisplayText();
    }

    protected Comparator getItemsComparator() {
        return PositionComparator.getInstance();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = SemanticsUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = SemanticsUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public static IDesc open(IStoryEditor editor) {
        return EventSelectionDialog.open(editor, null);
    }

    public static IDesc open(IStoryEditor editor, String title) {
        return EventSelectionDialog.open(editor, title, null);
    }

    public static IDesc open(IStoryEditor editor, String title, String message) {
        if (title == null) {
            title = "Select Event";
        }
        if (message == null) {
            message = "Select the appropriate event";
        }
        EventSelectionDialog dialog = new EventSelectionDialog(editor.getSite().getShell(), editor);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null) {
            return null;
        }
        if (result.length == 0) {
            return null;
        }
        return (IDesc)result[0];
    }

    protected class EventFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public EventFilter() {
            super((FilteredItemsSelectionDialog)EventSelectionDialog.this);
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IDesc) {
                return this.matchDesc((IDesc)item);
            }
            return false;
        }

        protected boolean matchDesc(IDesc desc) {
            if (!EventRep.getInstance().isType((IHasRep)desc)) {
                return false;
            }
            IEvent event = (IEvent)desc.getData();
            LinkedList<Object> names = new LinkedList<Object>();
            names.add(event.getEventClass());
            names.add(event.getTense());
            names.add(event.getAspect());
            for (IHasName iHasName : names) {
                if (!this.matches(iHasName.getName())) continue;
                return true;
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(event.getEventTokens());
            linkedList.add(event.getHeadTokens());
            linkedList.add(event.getCardinalityTokens());
            linkedList.add(event.getPolarityTokens());
            linkedList.add(event.getModalityTokens());
            for (IHasDisplayText iHasDisplayText : linkedList) {
                if (iHasDisplayText == null || !this.matches(iHasDisplayText.getDisplayText())) continue;
                return true;
            }
            return false;
        }
    }
}

