/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.handlers;

import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.valence.EventValence;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.semantics.core.rep.valence.ValenceRep;
import edu.mit.semantics.ui.dialogs.EventSelectionDialog;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateValenceHandler
extends AbstractHandler {
    public static final String PARAM_Valence = "edu.mit.semantics.ui.commandParameter.createValence.Valence";

    public void setEnabled(Object context) {
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)var;
            IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
            IDescSet selected = editor.getStoryModel().getData().getDescriptions(EventRep.getInstance()).closedSet((IHasPosition)tokens);
            this.setBaseEnabled(!selected.isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String message;
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!editor.getStoryModel().supports(ValenceRep.getInstance())) {
            return null;
        }
        Valence type = (Valence)event.getObjectParameterForExecution(PARAM_Valence);
        if (type == null) {
            type = Valence.UNKNOWN;
        }
        IHasPosition selection = editor.getSelectedRange();
        IDesc eventD = null;
        IDescSet eventDs = editor.getStoryModel().getData().getDescriptions(EventRep.getInstance()).closedSet(selection);
        if (eventDs.size() == 1) {
            eventD = (IDesc)eventDs.first();
        }
        if (eventD == null && (eventD = EventSelectionDialog.open(editor, null, message = "Please select an event to mark as an " + type.getName())) == null) {
            return null;
        }
        EventValence eval = new EventValence(type, eventD);
        long id = editor.getStoryModel().getNextID();
        Desc archD = new Desc(id, ValenceRep.getInstance(), eval.calculatePosition(), (IData)eval, null);
        archD.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)archD, (IMetaData)Origin.USER_SPECIFIED));
        archD.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)archD, (IMetaData)new Timing(start, "user")));
        AddDescriptionsChange change = new AddDescriptionsChange((IDesc)archD);
        editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        return null;
    }
}

