/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.widgets;

import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.Tense;
import edu.mit.parsing.core.rep.token.TokenDisplayText;
import edu.mit.semantics.core.rep.semrole.model.IFeaturesModel;
import edu.mit.semantics.ui.controllers.IPredicateController;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateCaptureWidget<C extends IPredicateController<?>>
extends DescCaptureWidget<C> {
    protected Button activeButton;
    protected Button thirdPersonButton;
    protected Combo tenseCombo;
    protected Combo aspectCombo;
    protected Combo formCombo;

    public PredicateCaptureWidget(Composite parent, int style, C controller) {
        super(parent, style, controller, (IDescDisplayText)TokenDisplayText.getInstance());
        controller.getFeaturesModel().addChangeListener((ChangeListener)((Object)this));
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        this.captureAction.setText("Capture Predicate");
        this.captureAction.setToolTipText("Capture predicate from editor");
        this.captureButton.setToolTipText(this.captureAction.getToolTipText());
        this.clearAction.setText("Clear Prediate");
        this.clearAction.setToolTipText("Clear selected predicate");
        this.clearButton.setToolTipText(this.clearAction.getToolTipText());
    }

    protected void createFollowingControls(Composite parent) {
        Tense option;
        GridLayout layout = new GridLayout(10, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Active?");
        this.activeButton = new Button(parent, 32);
        this.activeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IPredicateController)((AnnotationWidget)PredicateCaptureWidget.this).controller).setActive(PredicateCaptureWidget.this.activeButton.getSelection());
            }
        });
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Third Person?");
        this.thirdPersonButton = new Button(parent, 32);
        this.thirdPersonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IPredicateController)((AnnotationWidget)PredicateCaptureWidget.this).controller).setThirdPerson(PredicateCaptureWidget.this.thirdPersonButton.getSelection());
            }
        });
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Tense");
        this.tenseCombo = new Combo(parent, 8);
        Tense[] tenseArray = Tense.values();
        int n = tenseArray.length;
        int n2 = 0;
        while (n2 < n) {
            option = tenseArray[n2];
            this.tenseCombo.add(option.getName());
            ++n2;
        }
        this.tenseCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = PredicateCaptureWidget.this.tenseCombo.getSelectionIndex();
                ((IPredicateController)((AnnotationWidget)PredicateCaptureWidget.this).controller).setTense(idx > -1 ? Tense.values()[idx] : null);
            }
        });
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Aspect");
        this.aspectCombo = new Combo(parent, 8);
        tenseArray = Aspect.values();
        n = tenseArray.length;
        n2 = 0;
        while (n2 < n) {
            option = tenseArray[n2];
            this.aspectCombo.add(option.getName());
            ++n2;
        }
        this.aspectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = PredicateCaptureWidget.this.aspectCombo.getSelectionIndex();
                ((IPredicateController)((AnnotationWidget)PredicateCaptureWidget.this).controller).setAspect(idx > -1 ? Aspect.values()[idx] : null);
            }
        });
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Form");
        this.formCombo = new Combo(parent, 8);
        tenseArray = Form.values();
        n = tenseArray.length;
        n2 = 0;
        while (n2 < n) {
            option = tenseArray[n2];
            this.formCombo.add(option.getName());
            ++n2;
        }
        this.formCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = PredicateCaptureWidget.this.formCombo.getSelectionIndex();
                ((IPredicateController)((AnnotationWidget)PredicateCaptureWidget.this).controller).setForm(idx > -1 ? Form.values()[idx] : null);
            }
        });
        tenseArray = parent.getChildren();
        n = tenseArray.length;
        n2 = 0;
        while (n2 < n) {
            Tense control = tenseArray[n2];
            JFaceColors.setColors((Control)control, (Color)parent.getForeground(), (Color)parent.getBackground());
            ++n2;
        }
    }

    protected void updateFromModel() {
        super.updateFromModel();
        IFeaturesModel featuresModel = ((IPredicateController)this.controller).getFeaturesModel();
        boolean isActive = featuresModel.isActive();
        boolean isThirdPerson = featuresModel.isThirdPerson();
        Tense tense = featuresModel.getTense();
        Aspect aspect = featuresModel.getAspect();
        Form form = featuresModel.getForm();
        if (this.activeButton.getSelection() != isActive) {
            this.activeButton.setSelection(isActive);
        }
        if (this.thirdPersonButton.getSelection() != isThirdPerson) {
            this.thirdPersonButton.setSelection(isThirdPerson);
        }
        if (this.tenseCombo.getSelectionIndex() != tense.ordinal()) {
            this.tenseCombo.select(tense.ordinal());
        }
        if (this.aspectCombo.getSelectionIndex() != aspect.ordinal()) {
            this.aspectCombo.select(aspect.ordinal());
        }
        if (this.formCombo.getSelectionIndex() != form.ordinal()) {
            this.formCombo.select(form.ordinal());
        }
    }
}

