/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.clipboard;

import edu.mit.story.core.element.IStoryElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class StoryElementTransfer
extends ByteArrayTransfer {
    private static final StoryElementTransfer instance = new StoryElementTransfer();
    private static final String TYPE_NAME = "story-object-transfer-format";
    private static final int TYPEID = StoryElementTransfer.registerType((String)"story-object-transfer-format");

    public static StoryElementTransfer getInstance() {
        return instance;
    }

    private StoryElementTransfer() {
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IStoryElement)) {
            return;
        }
        IStoryElement object = (IStoryElement)data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(object);
            objectOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

