/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.content.RepCollectionContentProvider;
import edu.mit.story.ui.label.RepresentationLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class RepChooserDialog
extends ListDialog {
    RepCollectionContentProvider fContentProvider;
    private static RepresentationLabelProvider fLabelProvider;

    public RepChooserDialog(Shell parent) {
        this(null, parent);
    }

    public RepChooserDialog(IRep dontShow, Shell parent) {
        super(parent);
        this.setTitle(StoryUIMessages.DIALOG_SelectRepresentation_title);
        this.setMessage(StoryUIMessages.DIALOG_SelectRepresentation_message);
        this.setContentProvider(new RepCollectionContentProvider(dontShow));
        this.setLabelProvider((ILabelProvider)this.getLabelProvider());
    }

    protected RepresentationLabelProvider getLabelProvider() {
        if (fLabelProvider == null) {
            fLabelProvider = new RepresentationLabelProvider();
        }
        return fLabelProvider;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.getTableViewer().setInput((Object)StoryPlugin.getDefault().getRepManager());
        return result;
    }

    public IRep getSelectedRepresentation() {
        Object[] result = this.getResult();
        if (result == null) {
            return null;
        }
        if (result.length != 1) {
            return null;
        }
        return (IRep)result[0];
    }
}

