/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.core.model.StoryModelImporter;
import edu.mit.story.ui.editor.IStoryEditor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StorySelectionDialog
extends StatusDialog {
    public static final String defaultMessage = "Select a Story:";
    protected Text pathInput;
    protected FileDialog chooserDialog;
    protected String message = "Select a Story:";
    protected String initialPath = "";
    protected String selectedPath = null;

    public StorySelectionDialog(Shell parent, IStoryEditor target) {
        super(parent);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setInitialPath(String initialPath) {
        this.initialPath = initialPath;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        Label msg = new Label(composite, 0);
        msg.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        msg.setText(this.message);
        Label label = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText("Story File");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.pathInput = new Text(composite, 2048);
        this.pathInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StorySelectionDialog.this.dialogChanged();
            }
        });
        Button browse = new Button(composite, 8);
        browse.setText("B&rowse...");
        browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StorySelectionDialog.this.doBrowse();
            }

            public void widgetSelected(SelectionEvent e) {
                StorySelectionDialog.this.doBrowse();
            }
        });
        this.dialogChanged();
        return composite;
    }

    protected void doBrowse() {
        String path;
        if (this.chooserDialog == null) {
            this.chooserDialog = new FileDialog(this.getShell());
            this.chooserDialog.setText("Choose a story file");
            this.chooserDialog.setFilterExtensions(new String[]{"*.sty"});
            this.chooserDialog.setFilterPath(this.initialPath);
        }
        if ((path = this.chooserDialog.open()) != null) {
            this.pathInput.setText(path);
            this.pathInput.setSelection(this.pathInput.getText().length());
            this.pathInput.setFocus();
        }
    }

    protected void dialogChanged() {
        if (this.pathInput.getText().trim().length() == 0) {
            this.updateStatus((IStatus)new Status(4, " ", "Please enter a full path to a file"));
            this.selectedPath = null;
            return;
        }
        File file = new File(this.pathInput.getText());
        if (!file.exists()) {
            this.updateStatus((IStatus)new Status(4, " ", "File does not exist"));
            this.selectedPath = null;
            return;
        }
        StoryModelImporter importer = new StoryModelImporter();
        importer.setResourceName(file.getAbsolutePath());
        try {
            importer.importFromXML((Reader)new FileReader(file), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.updateStatus((IStatus)new Status(4, "edu.mit.story.core", "Story file not found", (Throwable)e));
            this.selectedPath = null;
            return;
        }
        catch (Exception e) {
            this.updateStatus((IStatus)new Status(4, "edu.mit.story.core", "Unable to parse story file", (Throwable)e));
            this.selectedPath = null;
            return;
        }
        this.selectedPath = this.pathInput.getText();
        this.updateStatus((IStatus)new Status(1, " ", "Press the OK button to accept"));
    }

    protected void cancelPressed() {
        this.selectedPath = null;
        super.cancelPressed();
    }
}

