/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.editor;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.editor.StoryEditorRedoAction;
import edu.mit.story.ui.actions.editor.StoryEditorUndoAction;
import edu.mit.story.ui.document.IStoryDocument;
import edu.mit.story.ui.document.StoryFileDocumentProvider;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryContentOutlinePage;
import edu.mit.story.ui.editor.StorySourceViewerConfiguration;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.operations.LinearUndoViolationUserApprover;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryEditor
extends AbstractDecoratedTextEditor
implements IStoryEditor,
ISelectionListener,
IModelListener {
    protected static char space = (char)32;
    IVerticalRuler fXMLVerticalRuler;
    ISourceViewer fXMLViewer;
    Composite externalParent;
    Composite internalParent;
    Composite fStoryGroup;
    Composite fSourceGroup;
    IStoryEditor.ViewLayout fViewLayout;
    boolean fWrapping = false;
    Point last = new Point(0, 0);
    final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    public static final String ID = "edu.mit.story.editor";

    public void dispose() {
        this.fXMLVerticalRuler = null;
        this.fXMLViewer = null;
        this.fSourceGroup = null;
        this.fStoryGroup = null;
        this.internalParent = null;
        this.externalParent = null;
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.setEditorContextMenuId("edu.mit.story.popup.storyEditor");
        IPreferenceStore store = this.getPreferenceStore();
        String viewLayoutName = store.getString("InitialStoryEditorLayout");
        this.fViewLayout = IStoryEditor.ViewLayout.valueOf(viewLayoutName);
        if (this.fViewLayout == null) {
            this.fViewLayout = IStoryEditor.ViewLayout.TABBED;
        }
        this.externalParent = parent;
        FillLayout fillLayout = new FillLayout(768);
        this.externalParent.setLayout((Layout)fillLayout);
        this.externalParent.setLayoutData((Object)new GridData(1808));
        if (this.fViewLayout == IStoryEditor.ViewLayout.HORIZONTAL) {
            this.setLayoutTiled(256);
        } else if (this.fViewLayout == IStoryEditor.ViewLayout.VERTICAL) {
            this.setLayoutTiled(512);
        } else if (this.fViewLayout == IStoryEditor.ViewLayout.TABBED) {
            this.setLayoutTabbed();
        }
        this.externalParent.layout(true);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.syncEditable();
    }

    public boolean isEditable() {
        return this.getSourceViewer().isEditable();
    }

    @Override
    public boolean isDisposed() {
        return this.getSourceViewer().getTextWidget().isDisposed();
    }

    protected void setLayoutTabbed() {
        if (this.externalParent == null) {
            return;
        }
        Composite oldParent = null;
        if (this.internalParent != null) {
            oldParent = this.internalParent;
        }
        this.internalParent = new TabFolder(this.externalParent, 1024);
        FillLayout fillLayout = new FillLayout(768);
        this.internalParent.setLayout((Layout)fillLayout);
        this.internalParent.setLayoutData((Object)new GridData(1808));
        if (this.fStoryGroup == null) {
            this.fStoryGroup = this.createStoryGroup(this.internalParent);
        } else {
            this.fStoryGroup.setParent(this.internalParent);
            this.fStoryGroup.setVisible(true);
        }
        final TabItem fStoryTab = new TabItem((TabFolder)this.internalParent, 0);
        fStoryTab.setControl((Control)this.fStoryGroup);
        fStoryTab.setText("Text");
        if (this.fSourceGroup == null) {
            this.fSourceGroup = this.createSourceGroup(this.internalParent);
        } else {
            this.fSourceGroup.setParent(this.internalParent);
            this.fSourceGroup.setVisible(true);
        }
        TabItem fSourceTab = new TabItem((TabFolder)this.internalParent, 0);
        fSourceTab.setControl((Control)this.fSourceGroup);
        fSourceTab.setText("XML");
        this.getStoryDocument().setXMLVisible(false);
        ((TabFolder)this.internalParent).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == fStoryTab) {
                    StoryEditor.this.getStoryDocument().setXMLVisible(false);
                } else {
                    StoryEditor.this.getStoryDocument().setXMLVisible(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (oldParent != null) {
            oldParent.dispose();
        }
    }

    protected void setLayoutTiled(int style) {
        if (this.externalParent == null) {
            return;
        }
        if (style != 512 & style != 256) {
            return;
        }
        if (this.internalParent instanceof SashForm) {
            ((SashForm)this.internalParent).setOrientation(style);
            return;
        }
        this.getStoryDocument().setXMLVisible(true);
        Composite oldParent = null;
        if (this.internalParent != null) {
            oldParent = this.internalParent;
        }
        this.internalParent = new SashForm(this.externalParent, style);
        if (this.fStoryGroup == null) {
            this.fStoryGroup = this.createStoryGroup(this.internalParent);
        } else {
            this.fStoryGroup.setParent(this.internalParent);
            this.fStoryGroup.setVisible(true);
        }
        if (this.fSourceGroup == null) {
            this.fSourceGroup = this.createSourceGroup(this.internalParent);
        } else {
            this.fSourceGroup.setParent(this.internalParent);
            this.fSourceGroup.setVisible(true);
        }
        if (oldParent != null) {
            oldParent.dispose();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        StyledText text = viewer.getTextWidget();
        text.setDragDetect(false);
        return viewer;
    }

    protected Composite createStoryGroup(Composite parent) {
        Composite group = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout(768);
        fillLayout.marginWidth = 0;
        group.setLayout((Layout)fillLayout);
        super.createPartControl(group);
        return group;
    }

    protected Composite createSourceGroup(Composite parent) {
        Composite group = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout(768);
        fillLayout.marginWidth = 0;
        group.setLayout((Layout)fillLayout);
        this.fXMLVerticalRuler = this.createVerticalRuler();
        int styles = 68354;
        this.fXMLViewer = new SourceViewer(group, this.fXMLVerticalRuler, styles);
        this.fXMLViewer.setEditable(false);
        SourceViewerConfiguration fConfiguration = new SourceViewerConfiguration();
        this.fXMLViewer.configure(fConfiguration);
        this.initializeViewerFont(this.fXMLViewer);
        this.fXMLViewer.setDocument(this.getStoryDocument().getXMLDocument());
        return group;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        Point curr = this.getSourceViewer().getSelectedRange();
        if (this.last.y == 0 && curr.y == 0 && this.last.x != curr.x) {
            this.setSelection(curr.x, 0);
        }
        this.last = curr;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"edu.mit.story.ui.storyEditorScope"});
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        FontData data;
        Font font = null;
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            font = JFaceResources.getFont((String)symbolicFontName);
        } else if (this.getPreferenceStore() != null && this.getPreferenceStore().contains("org.eclipse.jface.textfont") && !this.getPreferenceStore().isDefault("org.eclipse.jface.textfont") && (data = PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont")) != null) {
            font = new Font((Device)viewer.getTextWidget().getDisplay(), data);
        }
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        if (viewer.getDocument() != null) {
            StyledText styledText;
            Point selection = viewer.getSelectedRange();
            int topIndex = viewer.getTopIndex();
            StyledText parent = styledText = viewer.getTextWidget();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                parent = extension.getControl();
            }
            parent.setRedraw(false);
            styledText.setFont(font);
            if (this.fXMLVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fXMLVerticalRuler;
                e.setFont(font);
            }
            viewer.setSelectedRange(selection.x, selection.y);
            viewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = viewer.getTextWidget();
            styledText.setFont(font);
            if (this.fXMLVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fXMLVerticalRuler;
                e.setFont(font);
            }
        }
    }

    protected String getSymbolicFontName() {
        if (this.getConfigurationElement() != null) {
            return this.getConfigurationElement().getAttribute("symbolicFontName");
        }
        return null;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore[] stores = new IPreferenceStore[]{StoryUIPlugin.getDefault().getPreferenceStore(), this.getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.setSourceViewerConfiguration(new StorySourceViewerConfiguration(this));
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IUndoableStoryModel model;
        IStoryDocument document = this.getStoryDocument();
        if (document != null && (model = document.getStoryModel()) != null) {
            model.removeModelListener((IModelListener)this);
        }
        super.doSetInput(input);
        if (this.fXMLViewer != null) {
            this.fXMLViewer.setDocument(this.getStoryDocument().getXMLDocument());
        }
        if ((document = this.getStoryDocument()) != null && (model = document.getStoryModel()) != null) {
            model.addModelListener((IModelListener)this);
            ITextHover hover = this.getSourceViewerConfiguration().getTextHover(null, null);
            if (hover instanceof IHasStoryEditor) {
                IHasStoryEditor target = (IHasStoryEditor)hover;
                target.setStoryEditor(this);
            }
        }
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block23: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = MessageFormat.format("Editor_warning_save_delete", original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = "Editor_error_save_title";
                        String msg = MessageFormat.format("Editor_error_save_message", x.getMessage());
                        if (status != null) {
                            switch (status.getSeverity()) {
                                case 1: {
                                    MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                    break;
                                }
                                case 2: {
                                    MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                    break;
                                }
                                default: {
                                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                    break;
                                }
                            }
                        } else {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                        }
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected void createActions() {
        super.createActions();
        ActionUtils.createQuickFixAction(this);
    }

    protected void createUndoRedoActions() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        StoryEditorUndoAction undoAction = new StoryEditorUndoAction(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
        undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)undoAction);
        }
        StoryEditorRedoAction redoAction = new StoryEditorRedoAction(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
        redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)redoAction);
        }
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        history.addOperationApprover((IOperationApprover)new LinearUndoViolationUserApprover(this.getViewerUndoContext(), (IWorkbenchPart)this));
        history.addOperationApprover((IOperationApprover)new LinearUndoViolationUserApprover(this.getStoryModel().getUndoContext(), (IWorkbenchPart)this));
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new GroupMarker("group.save"));
        menu.add((IContributionItem)new Separator("additions"));
        if (this.isEditable()) {
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
        this.addAction(menu, "additions", "quickFix");
        this.addAction(menu, "group.add", "edu.mit.story.action.createDescription");
    }

    @Override
    public ISourceViewer getTextViewer() {
        return super.getSourceViewer();
    }

    @Override
    public IUndoContext getViewerUndoContext() {
        IUndoManager undoManager;
        if (this.getSourceViewer() instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)this.getSourceViewer()).getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public void modelChanged(StoryChangeEvent e) {
        if (e == null) {
            return;
        }
        this.setDirty(true);
        Change c = e.getChange(CharRep.getInstance());
        if (c != null && c.changed(Flag.CONFIG_CHANGED)) {
            this.syncEditable();
        }
    }

    protected void syncEditable() {
        IConfiguration config = this.getStoryModel().getData().getConfiguration(CharRep.getInstance());
        boolean editable = Boolean.parseBoolean((String)config.get((Object)"editable"));
        if (editable != this.getSourceViewer().isEditable()) {
            this.getSourceViewer().setEditable(editable);
            this.firePropertyChange(PROP_EDITABLE);
        }
    }

    public boolean validateEditorInputState() {
        if (!this.isEditable()) {
            return false;
        }
        return super.validateEditorInputState();
    }

    @Override
    public void setDirty(boolean value) {
        IDocumentProvider dp = this.getDocumentProvider();
        if (dp instanceof StoryFileDocumentProvider) {
            StoryFileDocumentProvider sdp = (StoryFileDocumentProvider)dp;
            boolean isDirty = sdp.isDirty(this.getEditorInput());
            if (isDirty == value) {
                return;
            }
            sdp.setDirty(this.getEditorInput(), value);
            this.firePropertyChange(257);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection == null || part == this) {
            return;
        }
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IStructuredSelection sel = SelectionUtils.castAsStructuredSelection(selection);
        if (sel == null) {
            return;
        }
        Object element = sel.getFirstElement();
        if (element instanceof IStoryModel) {
            return;
        }
        IHasPosition p = SelectionUtils.cast(element, IHasPosition.class);
        if (p == null) {
            return;
        }
        IDesc desc = SelectionUtils.cast(p, IDesc.class);
        if (desc != null && desc.getRep().isStructured()) {
            IStructuredData data = (IStructuredData)desc.getData();
            p = data.getDisplayPosition();
        }
        viewer.setSelectedRange(p.getOffset(), p.getLength());
        viewer.getTextWidget().showSelection();
        this.getVerticalRuler().update();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (IStoryEditor.class.equals((Object)adapter)) {
            return this;
        }
        if (IStoryModel.class.equals((Object)adapter)) {
            return this.getStoryModel();
        }
        if (IMutableStoryModel.class.equals((Object)adapter)) {
            return this.getStoryModel();
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return new StoryContentOutlinePage(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IHasPosition getSelectedRange() {
        Point p = this.getSourceViewer().getSelectedRange();
        return PositionUtils.toPosition((Point)p);
    }

    @Override
    public IStoryDocument getStoryDocument() {
        if (this.getDocumentProvider() == null) {
            return null;
        }
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        return doc instanceof IStoryDocument ? (IStoryDocument)doc : null;
    }

    @Override
    public IUndoableStoryModel getStoryModel() {
        IStoryDocument doc = this.getStoryDocument();
        return doc != null ? doc.getStoryModel() : null;
    }

    @Override
    public IStoryEditor.ViewLayout getViewLayout() {
        return this.fViewLayout;
    }

    @Override
    public void setSelection(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            viewer.setSelectedRange(offset, length);
        }
    }

    @Override
    public void setWrapping(boolean wrap) {
        if (this.fWrapping != wrap) {
            this.fWrapping = wrap;
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer != null) {
                viewer.getTextWidget().setWordWrap(this.fWrapping);
            }
            this.firePropertyChange(IStoryEditor.PROP_WRAPPING);
        }
    }

    @Override
    public boolean isWrapping() {
        return this.fWrapping;
    }

    @Override
    public void setViewLayout(IStoryEditor.ViewLayout viewState) {
        if (viewState == this.fViewLayout) {
            return;
        }
        if (viewState == IStoryEditor.ViewLayout.HORIZONTAL) {
            this.setLayoutTiled(256);
        } else if (viewState == IStoryEditor.ViewLayout.VERTICAL) {
            this.setLayoutTiled(512);
        } else if (viewState == IStoryEditor.ViewLayout.TABBED) {
            this.setLayoutTabbed();
        }
        this.fViewLayout = viewState;
        this.externalParent.layout(true);
        this.firePropertyChange(IStoryEditor.PROP_VIEWLAYOUT);
    }

    @Override
    public int getEditorWidth() {
        GC gc = new GC((Drawable)this.getSourceViewer().getTextWidget());
        Rectangle r = this.getSourceViewer().getTextWidget().getClientArea();
        int textWidth = r.width;
        StringBuffer sb = new StringBuffer();
        while (gc.textExtent((String)sb.toString()).x <= textWidth) {
            sb.append(space);
        }
        gc.dispose();
        return Math.max(0, sb.length() - 2);
    }

    @Override
    public boolean isMutable() {
        return this.getStoryModel() instanceof IMutableStoryModel;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static IStoryEditor getStoryEditor(IFile file) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            return part instanceof IStoryEditor ? (IStoryEditor)part : null;
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public IRepSet getSupported() {
        return this.getStoryModel().getSupported();
    }

    public Iterator<IRep> repIterator() {
        return this.getStoryModel().repIterator();
    }

    public int repSize() {
        return this.getStoryModel().repSize();
    }

    public boolean supports(IRep rep) {
        return this.getStoryModel().supports(rep);
    }

    public boolean supportsAll(Collection<? extends IRep> reps) {
        return this.getStoryModel().supportsAll(reps);
    }
}

