/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.model;

import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.XMLBackedStoryModel;
import edu.mit.story.core.model.change.CascadingModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IHasProgressMonitor;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class AsyncStoryModel
extends XMLBackedStoryModel
implements IUndoableStoryModel {
    private static final long serialVersionUID = 7323043588768849431L;
    private final IUndoContext undoContext = new ObjectUndoContext((Object)this);
    private boolean isIgnoringUpdates = false;
    private final UpdateJob updateJob;
    private final List<Instigation> changeQueue = Collections.synchronizedList(new LinkedList());

    public AsyncStoryModel(IRep primary) {
        super(primary);
        this.updateJob = new UpdateJob();
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel();
        }
        super.dispose();
    }

    public StoryChangeEvent applyChange(Object source, IModelChange change, boolean block) {
        change = change instanceof CascadingModelChange ? change : new CascadingModelChange(change);
        return this.applyChangeInternal(source, change, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoryChangeEvent applyChangeInternal(Object source, IModelChange change, boolean block) {
        if (block) {
            Instigation instigation;
            Thread displayThread = StoryUIPlugin.getDefault().getWorkbench().getDisplay().getThread();
            if (displayThread == Thread.currentThread()) {
                SWT.error((int)22);
            }
            Instigation instigation2 = instigation = new Instigation(source, change);
            synchronized (instigation2) {
                List<Instigation> list = this.changeQueue;
                synchronized (list) {
                    this.changeQueue.add(instigation);
                    if (this.updateJob.getState() == 0) {
                        this.updateJob.schedule();
                    }
                }
                try {
                    instigation.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return instigation.event;
        }
        List<Instigation> list = this.changeQueue;
        synchronized (list) {
            this.changeQueue.add(new Instigation(source, change));
            if (this.updateJob.getState() == 0) {
                this.updateJob.schedule();
            }
            return null;
        }
    }

    public void fireProviderChangeEventWithNotify(final StoryChangeEvent event, final Object lock) {
        if (event == null) {
            return;
        }
        if (event.provider != this) {
            return;
        }
        StoryUIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object[] objectArray = ((StoryModel)AsyncStoryModel.this).listeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IModelListener)listener).modelChanged(event);
                    ++n2;
                }
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        });
    }

    public boolean isIgnoringChanges() {
        return this.isIgnoringUpdates;
    }

    public void setIgnoreChanges(boolean value) {
        this.isIgnoringUpdates = value;
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    protected class Instigation {
        Object source;
        IModelChange change;
        StoryChangeEvent event = null;

        public Instigation(Object source, IModelChange change) {
            this.source = source;
            this.change = change;
        }

        public void setEvent(StoryChangeEvent event) {
            this.event = event;
        }
    }

    public class ModelChangeOperation
    extends AbstractOperation {
        public final boolean viewerChanged;
        public final IModelChange doChange;
        public final IModelChange undoChange;
        public boolean done;

        public ModelChangeOperation(String name, boolean viewerChanged, IModelChange doChange, IModelChange undoChange) {
            super(name);
            this.done = true;
            this.viewerChanged = viewerChanged;
            this.doChange = doChange;
            this.undoChange = undoChange;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.undoChange != null) {
                AsyncStoryModel.this.applyChangeInternal((Object)this, this.undoChange, false);
            }
            this.done = false;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.doChange != null) {
                AsyncStoryModel.this.applyChangeInternal((Object)this, this.doChange, false);
            }
            this.done = true;
            return Status.OK_STATUS;
        }

        public boolean canRedo() {
            return !this.done;
        }

        public boolean canUndo() {
            return this.done;
        }

        public boolean didViewerChange() {
            return this.viewerChanged;
        }
    }

    protected class UpdateJob
    extends Job {
        boolean shouldCancel;
        IOperationHistory history;

        public UpdateJob() {
            super(StoryUIMessages.JOB_DescriptionUpdater_name);
            this.shouldCancel = false;
            this.setName(StoryUIMessages.JOB_DescriptionUpdater_name);
            this.setPriority(10);
            this.history = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Instigation instigation = null;
            while (true) {
                List list = AsyncStoryModel.this.changeQueue;
                synchronized (list) {
                    Instigation merge = null;
                    int i = 0;
                    while (i < AsyncStoryModel.this.changeQueue.size() - 2) {
                        merge = this.combineChanges((Instigation)AsyncStoryModel.this.changeQueue.get(i), (Instigation)AsyncStoryModel.this.changeQueue.get(i + 1));
                        if (merge != null) {
                            AsyncStoryModel.this.changeQueue.set(i, merge);
                            AsyncStoryModel.this.changeQueue.remove(i + 1);
                            --i;
                        }
                        ++i;
                    }
                    instigation = AsyncStoryModel.this.changeQueue.isEmpty() ? null : (Instigation)AsyncStoryModel.this.changeQueue.remove(0);
                }
                if (instigation == null) break;
                if (instigation.change instanceof IHasProgressMonitor) {
                    ((IHasProgressMonitor)instigation.change).setProgressMonitor(monitor);
                }
                StoryChangeEvent event = null;
                try {
                    event = instigation.change.apply(instigation.source, (IMutableStoryModel)AsyncStoryModel.this);
                }
                catch (Exception e) {
                    LogUtils.logError((Plugin)StoryUIPlugin.getDefault(), (Throwable)e, (String)StoryUIMessages.MSG_ExceptionThrownDuringApplyChange);
                }
                instigation.setEvent(event);
                if (event != null && !ModelChangeOperation.class.isAssignableFrom(instigation.source.getClass())) {
                    boolean viewerChanged = instigation.source instanceof IDocument;
                    ModelChangeOperation op = new ModelChangeOperation(instigation.change.getName(), viewerChanged, event.doChange, event.undoChange);
                    IUndoContext context = AsyncStoryModel.this.getUndoContext();
                    op.addContext(context);
                    Display.getDefault().asyncExec(new Runnable((IUndoableOperation)op){
                        private final /* synthetic */ IUndoableOperation val$op;
                        {
                            this.val$op = iUndoableOperation;
                        }

                        public void run() {
                            UpdateJob.this.history.add(this.val$op);
                        }
                    });
                }
                AsyncStoryModel.this.fireProviderChangeEventWithNotify(event, instigation);
                Instigation instigation2 = instigation;
                synchronized (instigation2) {
                    instigation.notifyAll();
                }
            }
            return Status.OK_STATUS;
        }

        public void internalCancel() {
            this.shouldCancel = true;
        }

        protected Instigation combineChanges(Instigation first, Instigation second) {
            if (first.source != second.source) {
                return null;
            }
            IModelChange combination = first.change.combineWith(second.change);
            return combination == null ? null : new Instigation(first.source, combination);
        }
    }
}

