/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.build.StoryNature;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateCorpusOperation
extends WorkspaceModifyOperation {
    private final IPath path;
    private final IProject project;

    public CreateCorpusOperation(IPath path, IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.project = project;
    }

    public IPath getPath() {
        return this.path;
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            if (monitor.isCanceled()) {
                return;
            }
            String message = NLS.bind((String)StoryUIMessages.MSG_PROGRESS_CreatingProject, (Object)this.project.getName());
            monitor.beginTask(message, 4000);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.project.getName());
            description.setLocation(this.path);
            if (monitor.isCanceled()) {
                return;
            }
            this.project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                return;
            }
            this.project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            StoryNature.addStoryNature(this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            monitor.worked(1000);
            return;
        }
        finally {
            monitor.done();
        }
    }
}

