/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSpecificationGroup
extends Composite
implements INotifyingMessageProvider {
    Text pathField;
    FileDialog dialog;
    IValidator<String> validator;
    protected boolean outOfSync = true;
    protected IMessageProvider message = Message.NO_MESSAGE;
    private final ChangeNotifier notifier = new ChangeNotifier();

    public PathSpecificationGroup(Composite parent) {
        this(parent, null);
    }

    public PathSpecificationGroup(Composite parent, String fieldHeader) {
        this(parent, fieldHeader, null);
    }

    public PathSpecificationGroup(Composite parent, String fieldHeader, IValidator<String> validator) {
        super(parent, 0);
        this.validator = validator;
        if (fieldHeader == null) {
            fieldHeader = StoryUIMessages.PathSpecificationGroup_PathEntry_label;
        }
        this.createContents(fieldHeader);
    }

    protected void createContents(String header) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 0);
        label.setText(header);
        this.pathField = new Text((Composite)this, 2052);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.pathField.setLayoutData((Object)data);
        this.pathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathSpecificationGroup.this.outOfSync = true;
                PathSpecificationGroup.this.notifyChangeListeners(PathSpecificationGroup.this.pathField);
            }
        });
        Button browseButton = new Button((Composite)this, 16392);
        browseButton.setText(StoryUIMessages.PathSpecificationGroup_BrowseButton_label);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PathSpecificationGroup.this.dialog = new FileDialog(PathSpecificationGroup.this.getShell(), 36864);
                String path = PathSpecificationGroup.this.dialog.open();
                if (path != null) {
                    PathSpecificationGroup.this.pathField.setText(path);
                    PathSpecificationGroup.this.pathField.setSelection(path.length());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean setFocus() {
        return this.pathField.setFocus();
    }

    public IPath getFilePath() {
        return new Path(this.pathField.getText()).makeAbsolute();
    }

    public void setFilePath(String filePath) {
        if (filePath == null) {
            this.pathField.setText("");
        } else {
            this.pathField.setText(filePath);
        }
        Event e = new Event();
        e.widget = this.pathField;
        this.pathField.notifyListeners(24, e);
    }

    public String getMessage() {
        if (this.outOfSync) {
            this.doValidate();
        }
        return this.message.getMessage();
    }

    public int getMessageType() {
        if (this.outOfSync) {
            this.doValidate();
        }
        return this.message.getMessageType();
    }

    protected void doValidate() {
        Object object = this.message = this.validator == null ? Message.NO_MESSAGE : this.validator.validate((Object)this.pathField.getText());
        if (this.message == null) {
            this.message = Message.NO_MESSAGE;
        }
        this.outOfSync = false;
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

