/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.property.CorpusConfiguration;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.ICorpusConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.ModelConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepManager;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.controllers.IRepSelectionController;
import edu.mit.story.ui.controllers.RepSelectionConsistentController;
import edu.mit.story.ui.document.CreateConfiguredCorpusRunnable;
import edu.mit.story.ui.model.IRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import edu.mit.story.ui.wizards.page.FactoryConfigPage;
import edu.mit.story.ui.wizards.page.RepConfigPage;
import edu.mit.story.ui.wizards.page.SpecifyCorpusRepsPage;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewCorpusWizard
extends Wizard
implements INewWizard {
    public static final String PAGE_CorpusNameAndLocation_name = "CorpusNameAndLocation";
    public static final String PAGE_CorpusRepresentations_name = "CorpusRepresentations";
    protected final IRepSelectionController<? extends IRepSelectionModel> controller;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected WizardNewProjectCreationPage projectPage;
    protected SpecifyCorpusRepsPage repPage;
    protected RepConfigPage repConfigPage;
    protected FactoryConfigPage factoryConfigPage;

    public NewCorpusWizard() {
        IRepManager m = StoryPlugin.getDefault().getRepManager();
        RepSelectionModel model = new RepSelectionModel();
        model.getSupported().addAll((Collection<IRep>)m.getSupported());
        for (IRep rep : StoryUIPlugin.getDefault().getDefaultReps()) {
            model.setSelected(rep, true);
        }
        for (IRep rep : m.getRequired()) {
            model.setRequired(rep, true);
        }
        this.controller = new RepSelectionConsistentController<RepSelectionModel>(model);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(StoryUIMessages.WIZARD_NewCorpus_title);
        this.setDefaultPageImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/corpus_wiz.gif"));
    }

    public void addPages() {
        this.projectPage = new WizardNewProjectCreationPage(PAGE_CorpusNameAndLocation_name);
        this.projectPage.setTitle(StoryUIMessages.WIZARD_PAGE_CreateNewCorpus_title);
        this.projectPage.setDescription(StoryUIMessages.WIZARD_PAGE_CreateNewCorpus_description);
        this.addPage((IWizardPage)this.projectPage);
        this.repPage = new SpecifyCorpusRepsPage(this.controller);
        this.addPage((IWizardPage)this.repPage);
        this.repConfigPage = new RepConfigPage();
        this.addPage((IWizardPage)this.repConfigPage);
        this.factoryConfigPage = new FactoryConfigPage();
        this.addPage((IWizardPage)this.factoryConfigPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next == this.repConfigPage) {
            this.repConfigPage.setRepresentations(this.controller.getModel().getIncluded());
        }
        if (next == this.factoryConfigPage) {
            this.factoryConfigPage.setRepresentations(this.controller.getModel().getIncluded());
        }
        return next;
    }

    public boolean performFinish() {
        IPath path = this.projectPage.useDefaults() ? null : this.projectPage.getLocationPath();
        IProject project = this.projectPage.getProjectHandle();
        ICorpusConfiguration projectConfig = this.createProjectConfiguration();
        CreateConfiguredCorpusRunnable op = new CreateConfiguredCorpusRunnable(path, project, projectConfig);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        WorkbenchUtils.selectAndReveal((IResource)project, this.workbench.getActiveWorkbenchWindow());
        return true;
    }

    protected ICorpusConfiguration createProjectConfiguration() {
        String name = this.projectPage.getProjectName();
        String desc = "New project configuration";
        CorpusConfiguration result = new CorpusConfiguration((IDescriptor)new Descriptor(name, name, desc));
        IRepSelectionModel model = this.controller.getModel();
        result.addAllSupport(model.getIncluded());
        for (IRep rep : model.getRequired()) {
            result.setRequired(rep, true);
        }
        Map<IRep, IConfiguration> repConfigs = this.repConfigPage.getConfigurations();
        for (IConfiguration config : repConfigs.values()) {
            result.getConfigurations().put(config.getID(), config);
        }
        IRepConfiguration factConfigs = this.factoryConfigPage.getConfiguration();
        Iterator i = factConfigs.repIterator();
        while (i.hasNext()) {
            IRep rep = (IRep)i.next();
            String key = ModelConfiguration.getFactoryKey((IRep)rep);
            String id = (String)factConfigs.get((Object)rep.getID());
            IConfiguration config = (IConfiguration)factConfigs.getConfigurations().get(rep.getID());
            if (id != null) {
                result.put((Object)key, (Object)id);
            }
            if (config == null) continue;
            result.getConfigurations().put(key, config);
        }
        return result;
    }
}

