/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import com.google.common.collect.Table;
import edu.mit.story.core.datamodel.IBatchPairModel;
import edu.mit.story.ui.controllers.IBatchPairController;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePairsPage
extends WizardPage {
    public static final String NAME = ResourcePairsPage.class.getSimpleName();
    private final IBatchPairController<? extends IBatchPairModel> controller;
    protected CheckboxTableViewer tableViewer;

    public ResourcePairsPage(IBatchPairController<? extends IBatchPairModel> controller) {
        this(NAME, controller);
    }

    public ResourcePairsPage(String pageName, IBatchPairController<? extends IBatchPairModel> controller) {
        super(pageName);
        if (controller == null) {
            throw new NullPointerException();
        }
        this.controller = controller;
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        Table table = new Table(parent, 2594);
        table.setHeaderVisible(true);
        TableColumn c = new TableColumn(table, 2048);
        c = new TableColumn(table, 2048);
        c.setText("Source");
        c = new TableColumn(table, 2048);
        c.setText("Target");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ResourcePairLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ResourcePairContentProvider());
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setInput((Object)((IBatchPairModel)this.controller.getModel()).getResourcePairs());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Table.Cell cell = (Table.Cell)event.getElement();
                ResourcePairsPage.this.controller.selectPair((IFile)cell.getRowKey(), (IFile)cell.getColumnKey(), (Boolean)cell.getValue() == false);
            }
        });
        this.setControl((Control)parent);
        ((IBatchPairModel)this.controller.getModel()).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ResourcePairsPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected void updateFromModel() {
        IBatchPairModel model = (IBatchPairModel)this.controller.getModel();
        this.tableViewer.refresh();
        for (Table.Cell cell : model.getResourcePairs().cellSet()) {
            if (((Boolean)cell.getValue()).booleanValue() == this.tableViewer.getChecked((Object)cell)) continue;
            this.tableViewer.setChecked((Object)cell, ((Boolean)cell.getValue()).booleanValue());
        }
        this.setMessage(model.getMessage(), model.getMessageType());
        this.setPageComplete(model.getMessageType() != 3);
    }

    protected class ResourcePairContentProvider
    implements IStructuredContentProvider {
        protected ResourcePairContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof com.google.common.collect.Table) {
                com.google.common.collect.Table t = (com.google.common.collect.Table)inputElement;
                return t.cellSet().toArray();
            }
            return null;
        }
    }

    protected class ResourcePairLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        protected ResourcePairLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Table.Cell cell = (Table.Cell)element;
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.getWorkspaceRelativePath((IFile)cell.getRowKey());
                }
                case 2: {
                    return this.getWorkspaceRelativePath((IFile)cell.getColumnKey());
                }
            }
            return null;
        }

        protected String getWorkspaceRelativePath(IFile file) {
            IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath absPath = file.getFullPath();
            IPath relPath = absPath.removeFirstSegments(absPath.matchingFirstSegments(rootPath));
            relPath = relPath.setDevice("");
            relPath = relPath.makeRelative();
            return relPath.toOSString();
        }
    }
}

