/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions.delegates;

import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.CreateReferentChange;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateReferentDelegate
extends AbstractDelegate {
    IStoryEditor currentEditor;

    public void init(IAction action) {
        action.setDisabledImageDescriptor(DiscourseUIPlugin.getDefault().getImageRegistry().getDescriptor("dtool16/create_referent.gif"));
    }

    public void run(IAction action) {
        if (CreateReferentDelegate.canCreateReferent(this.currentEditor)) {
            CreateReferentDelegate.createReferent((Object)this, this.currentEditor);
        } else {
            PlatformUI.getWorkbench().getDisplay().beep();
        }
    }

    public void setActivePart(IWorkbenchPart activePart) {
        IStoryEditor newEditor;
        this.currentEditor = newEditor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
    }

    public void updateAction(IAction action) {
        boolean enabled = this.currentEditor != null && this.currentEditor.getStoryModel().supports(ReferentRep.getInstance());
        action.setEnabled(enabled);
    }

    public void dispose() {
        this.currentEditor = null;
        super.dispose();
    }

    public static boolean canCreateReferent(IStoryEditor editor) {
        IHasPosition p = editor.getSelectedRange();
        IStoryData data = editor.getStoryModel().getData();
        if (!data.supports(ReferentRep.getInstance())) {
            return false;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)p, (IStoryData)data);
        if (tokens.isEmpty()) {
            return false;
        }
        p = new SimplePosition((IHasPosition)tokens);
        return Referent.isReferenceInModel((IHasPosition)p, (IStoryData)data) == null;
    }

    public static boolean createReferent(Object source, IStoryEditor editor) {
        Timing timing = new Timing("user", true);
        if (editor == null) {
            return false;
        }
        IHasPosition p = editor.getSelectedRange();
        IUndoableStoryModel model = editor.getStoryModel();
        if (!model.supports(ReferentRep.getInstance())) {
            return false;
        }
        IDescSet tokens = ParsingUtils.getTokens((IHasPosition)p, (IStoryData)model.getData());
        if (tokens.isEmpty()) {
            return false;
        }
        model.applyChange(source, (IModelChange)new CreateReferentChange(null, (IHasPosition)tokens, (ITiming)timing), false);
        return true;
    }
}

