/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.controllers;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.coref.model.CorefModel;
import edu.mit.discourse.core.rep.coref.model.ICorefModel;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.ui.controllers.ICorefController;
import edu.mit.discourse.ui.label.RefExpLabelProvider;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.AbstractSelectionDialogCaptureStrategy;
import edu.mit.story.ui.controllers.DescController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorefController
implements ICorefController {
    private final IStoryEditor editor;
    private final ICorefModel model;
    private final IDescController<IDescModel> refExpController;

    public CorefController(IStoryEditor editor, String refAnnoID) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.model = new CorefModel((IStoryModel)editor.getStoryModel());
        DescModel refexpModel = new DescModel((IStoryModel)editor.getStoryModel(), new IRep[]{RefExpRep.getInstance()});
        RefExpSelectionDialogCaptureStrategy stragety = new RefExpSelectionDialogCaptureStrategy(editor, (IDescModel)refexpModel);
        this.refExpController = new DescController((IDescModel)refexpModel, refAnnoID, editor, (ICaptureStrategy)stragety);
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public ICorefModel getModel() {
        return this.model;
    }

    @Override
    public IDescController<IDescModel> getRefExpController() {
        return this.refExpController;
    }

    @Override
    public void addReferringExpression() {
        IDescModel widgetModel = this.refExpController.getDescModel();
        this.getModel().getReferentialExpressions().add((Object)widgetModel.getDesc());
        widgetModel.clear();
    }

    @Override
    public void commit() {
        ICorefModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing timing = new Timing(model.getStart(), "user");
        ICoref data = model.create();
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)CorefRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }

    @Override
    public void edit(IDesc desc) {
        if (CorefRep.getInstance().isType((IHasRep)desc)) {
            this.model.load(desc);
        }
    }

    public void dispose() {
        this.refExpController.dispose();
    }

    @Override
    public void clear() {
        this.getModel().clear();
        this.refExpController.clear();
    }

    @Override
    public void setName(String text) {
        this.model.setName(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefExpSelectionDialogCaptureStrategy
    extends AbstractSelectionDialogCaptureStrategy {
        private final IDescModel model;
        private ILabelProvider lp;

        public RefExpSelectionDialogCaptureStrategy(IStoryEditor editor, IDescModel model) {
            super(editor);
            if (model == null) {
                throw new NullPointerException();
            }
            this.model = model;
        }

        protected ILabelProvider getLabelProvider() {
            if (this.lp == null) {
                this.lp = new RefExpLabelProvider(this.getStoryEditor());
            }
            return this.lp;
        }

        protected Set<IRep> getReps() {
            return this.model.getReps();
        }
    }
}

