/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.hovers;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CorefHover
extends StoryTextHover {
    public CorefHover() {
        super(CorefRep.getInstance());
    }

    public String getHoverInfo(IStoryModel editor, int hoverOffset, IHasPosition selection) {
        ICoref coref;
        if (!editor.supports(CorefRep.getInstance())) {
            return null;
        }
        SimplePosition p = new SimplePosition(hoverOffset, 0);
        IDescSet corefDescs = editor.getData().getDescriptions(CorefRep.getInstance()).closedSet((IHasPosition)p);
        if (corefDescs.isEmpty()) {
            return null;
        }
        LinkedHashMap<IDesc, IDescSet> found = new LinkedHashMap<IDesc, IDescSet>();
        for (IDesc d : corefDescs) {
            coref = (ICoref)d.getData();
            IDescSet overlap = coref.getReferentialExpressions().closedSet((IHasPosition)p);
            if (overlap.isEmpty()) continue;
            found.put(d, overlap);
        }
        if (found.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Coreference Groups:\n");
        Iterator i = found.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            coref = (ICoref)((IDesc)e.getKey()).getData();
            sb.append(coref.getName());
            sb.append(" (");
            sb.append(((IDesc)e.getKey()).getID());
            sb.append(")\n");
            Iterator j = ((IDescSet)e.getValue()).iterator();
            while (j.hasNext()) {
                IDesc d = (IDesc)j.next();
                sb.append("\t\t");
                IRefExp refexp = (IRefExp)d.getData();
                sb.append(refexp.getDisplayText());
                sb.append(" (");
                sb.append(Long.toString(d.getID()));
                sb.append(')');
                if (!j.hasNext()) continue;
                sb.append('\n');
            }
            if (!i.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

