/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.views;

import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.widgets.RelationCreatorWidget;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class RelationCreatorView
extends PageBookView {
    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(DiscourseUIMessages.MSG_NoRelationEnabledModelAvailable);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return null;
        }
        RelationCreatorPage page = new RelationCreatorPage((IStoryEditor)part);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        return page != null ? page.getActiveEditor() : null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IStoryEditor;
    }

    public static class RelationCreatorPage
    extends Page
    implements IAdaptable {
        IStoryEditor fEditor;
        IAction propAction;
        ActionGroup undoRedoActions;
        RelationCreatorWidget creatorWidget;

        public RelationCreatorPage(IStoryEditor part) {
            this.fEditor = part;
        }

        public void createControl(Composite parent) {
            this.creatorWidget = new RelationCreatorWidget(parent, 0, this.fEditor);
            this.creatorWidget.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
            this.createActions();
        }

        protected void createActions() {
            this.propAction = new EditPropertiesAction();
            this.undoRedoActions = new StoryEditorUndoRedoActionGroup(this.fEditor);
            IActionBars actionBars = this.getSite().getActionBars();
            this.undoRedoActions.fillActionBars(actionBars);
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), this.propAction);
            this.undoRedoActions.updateActionBars();
        }

        public Control getControl() {
            return this.creatorWidget;
        }

        public RelationCreatorWidget getWidget() {
            return this.creatorWidget;
        }

        public void setFocus() {
            this.creatorWidget.setFocus();
        }

        public void dispose() {
            this.creatorWidget.removeAnnotations();
            super.dispose();
        }

        public void editRelation(IDesc desc, IStoryData data) {
            this.creatorWidget.editRelation(desc, data);
        }

        public Object getAdapter(Class adapter) {
            return this.fEditor.getAdapter(adapter);
        }

        protected class EditPropertiesAction
        extends Action {
            protected EditPropertiesAction() {
            }

            public void run() {
                RelationCreatorPage.this.getWidget().editProperties();
            }
        }
    }
}

