/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.widgets;

import edu.mit.discourse.core.rep.relation.IAdjunct;
import edu.mit.discourse.core.rep.relation.IArgument;
import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.core.rep.relation.RelationRep;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.relation.AdjunctProxy;
import edu.mit.discourse.ui.relation.ArgumentProxy;
import edu.mit.discourse.ui.relation.RelationProxy;
import edu.mit.discourse.ui.relprops.IRelPropManager;
import edu.mit.discourse.ui.widgets.LexicalMarkerCaptureWidget;
import edu.mit.discourse.ui.widgets.RelationViewer;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.IHasProperties;
import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.property.IPropertyModifyListener;
import edu.mit.story.core.property.Property;
import edu.mit.story.core.property.PropertyModifyEvent;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.util.IClearable;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationCreatorWidget
extends Composite
implements IClearable,
INotifyingMessageProvider,
ChangeListener,
IPropertyModifyListener,
IPropertyChangeListener {
    private static final String[] fixedOptions = new String[]{"New Argument", "Adjunct to Lexical Marker", "Adjunct to Argument 1", "Adjunct to Argument 2"};
    ListenerList pListeners = new ListenerList();
    MessageProviderManager manager;
    IStoryEditor editor;
    List<AnnotationWidget<?>> widgets = new ArrayList(4);
    Combo addCombo;
    EditableRelationViewer viewer;
    RelationPropertyEditor propertyEditor;
    private final ChangeNotifier notifier = new ChangeNotifier();
    final RelationProxy relProxy;
    LexicalMarkerCaptureWidget<?> lmWidget;
    SegmentSetCaptureWidget<?> argOneWidget;
    SegmentSetCaptureWidget<?> argTwoWidget;
    SegmentSetCaptureWidget<?> addWidget;
    Button lmEntButton;
    Button oneEntButton;
    Button twoEntButton;
    Button adjEntButton;
    Button createButton;
    Button clearButton;
    Button removeButton;
    Button captureButton;
    IPreferenceStore store;
    private static final String space = " ";
    private IDesc descBeingEdited = null;

    public RelationCreatorWidget(Composite parent, int style, IStoryEditor editor) {
        super(parent, style);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        Message message = new Message(DiscourseUIMessages.MSG_RelationCreatorInstructions, 1);
        this.manager = new MessageProviderManager((IMessageProvider)message, (ChangeListener)this);
        JFaceColors.setColors((Control)this, (Color)parent.getForeground(), (Color)StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.relProxy = new RelationProxy();
        this.relProxy.addChangeListener(this);
        this.createControl(this, style);
        this.store = DiscourseUIPlugin.getDefault().getPreferenceStore();
    }

    protected void createControl(Composite parent, int style) {
        parent.setLayout((Layout)new GridLayout(3, false));
        this.createCaptureWidgets(parent);
        this.createEditors(parent);
        this.updateControls();
    }

    protected void createCaptureWidgets(Composite parent) {
        String errorMsg = "{0} is not set; it must be set before you can create a relation.";
        Composite widgetParent = new Composite(parent, 0);
        widgetParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        widgetParent.setLayout((Layout)layout);
        JFaceColors.setColors((Control)widgetParent, (Color)parent.getForeground(), (Color)parent.getBackground());
        Label label = this.createWidgetLabel(widgetParent, "Lexical Marker");
        this.lmEntButton = this.createNewEntityButton(widgetParent);
        this.lmWidget.setData("name", "edu.mit.story.ui.annotation.target1");
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.lmWidget.setLayoutData(data);
        label = this.createWidgetLabel(widgetParent, "Argument One");
        this.oneEntButton = this.createNewEntityButton(widgetParent);
        this.argOneWidget = this.createWidget(widgetParent, "edu.mit.story.ui.annotation.target2", NLS.bind((String)errorMsg, (Object)label.getText()));
        label = this.createWidgetLabel(widgetParent, "Argument Two");
        this.twoEntButton = this.createNewEntityButton(widgetParent);
        this.argTwoWidget = this.createWidget(widgetParent, "edu.mit.story.ui.annotation.target3", NLS.bind((String)errorMsg, (Object)label.getText()));
        this.createWidgetLabel(widgetParent, "Additional");
        this.adjEntButton = this.createNewEntityButton(widgetParent);
        this.addWidget = this.createWidget(widgetParent, "edu.mit.story.ui.annotation.target4", null);
        this.createLowerButtonGroup(widgetParent);
    }

    protected void createLowerButtonGroup(Composite widgetParent) {
        Label label = new Label(widgetParent, 0);
        GridData data = new GridData(4, 4, false, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        JFaceColors.setColors((Control)label, (Color)widgetParent.getForeground(), (Color)widgetParent.getBackground());
        Composite comboGroup = new Composite(widgetParent, 0);
        JFaceColors.setColors((Control)comboGroup, (Color)widgetParent.getForeground(), (Color)widgetParent.getBackground());
        comboGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comboGroup.setLayout((Layout)layout);
        this.addCombo = new Combo(comboGroup, 8);
        String[] stringArray = fixedOptions;
        int n = fixedOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String fixedOption = stringArray[n2];
            this.addCombo.add(fixedOption);
            ++n2;
        }
        this.addCombo.select(0);
        this.addCombo.setEnabled(false);
        Button commitButton = new Button(comboGroup, 8);
        commitButton.setText("Commit");
        commitButton.setEnabled(false);
        commitButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStoryData data = RelationCreatorWidget.this.editor.getStoryModel().getData();
                int idx = RelationCreatorWidget.this.addCombo.getSelectionIndex();
                switch (idx) {
                    case 0: {
                        RelationCreatorWidget.this.relProxy.addArgument((Collection<ISegment>)((ISegmentSetController)RelationCreatorWidget.this.addWidget.getController()).getModel().getSegments(), RelationCreatorWidget.this.adjEntButton.getSelection(), data);
                        break;
                    }
                    case 1: {
                        RelationCreatorWidget.this.relProxy.lexMarker.addAdjunct((Collection<ISegment>)((ISegmentSetController)RelationCreatorWidget.this.addWidget.getController()).getModel().getSegments(), RelationCreatorWidget.this.adjEntButton.getSelection(), data);
                        break;
                    }
                    case 2: {
                        RelationCreatorWidget.this.relProxy.argOne.addAdjunct((Collection<ISegment>)((ISegmentSetController)RelationCreatorWidget.this.addWidget.getController()).getModel().getSegments(), RelationCreatorWidget.this.adjEntButton.getSelection(), data);
                        break;
                    }
                    case 3: {
                        RelationCreatorWidget.this.relProxy.argTwo.addAdjunct((Collection<ISegment>)((ISegmentSetController)RelationCreatorWidget.this.addWidget.getController()).getModel().getSegments(), RelationCreatorWidget.this.adjEntButton.getSelection(), data);
                        break;
                    }
                    default: {
                        int addArgIdx = idx - fixedOptions.length;
                        ArgumentProxy proxy = RelationCreatorWidget.this.relProxy.getAdditionalArgs().get(addArgIdx);
                        proxy.addAdjunct((Collection<ISegment>)((ISegmentSetController)RelationCreatorWidget.this.addWidget.getController()).getModel().getSegments(), RelationCreatorWidget.this.adjEntButton.getSelection(), data);
                    }
                }
                ((ISegmentSetController)RelationCreatorWidget.this.addWidget.getController()).clear();
            }
        });
        Composite buttonGroup = new Composite(widgetParent, 0);
        JFaceColors.setColors((Control)buttonGroup, (Color)widgetParent.getForeground(), (Color)widgetParent.getBackground());
        buttonGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        label = new Label(buttonGroup, 0);
        data = new GridData(4, 4, true, false);
        label.setLayoutData((Object)data);
        JFaceColors.setColors((Control)label, (Color)widgetParent.getForeground(), (Color)widgetParent.getBackground());
        this.createButton = new Button(buttonGroup, 0);
        this.createButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RelationCreatorWidget.this.createRelation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.clearButton = new Button(buttonGroup, 0);
        this.clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RelationCreatorWidget.this.clear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected Label createWidgetLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        JFaceColors.setColors((Control)label, (Color)parent.getForeground(), (Color)parent.getBackground());
        return label;
    }

    protected SegmentSetCaptureWidget<?> createWidget(Composite parent, String annoID, String errMsg) {
        return null;
    }

    protected Button createNewEntityButton(Composite parent) {
        Button newButton = new Button(parent, 2);
        newButton.setImage(DiscourseUIPlugin.getDefault().getImageRegistry().get("etool16/create_referent.gif"));
        newButton.setToolTipText("Create Entity");
        newButton.setEnabled(false);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationCreatorWidget.this.updateControls();
            }
        });
        return newButton;
    }

    protected void createEditors(Composite parent) {
        this.viewer = new EditableRelationViewer(parent, 2048, 0x1000000);
        this.viewer.setLayoutData(new GridData(4, 4, true, true));
        this.propertyEditor = new RelationPropertyEditor(parent, 2048, false);
        this.propertyEditor.setInput((IHasProperties)this.relProxy);
        this.propertyEditor.setLayoutData(new GridData(4, 4, true, true));
        this.propertyEditor.addPropertyModifyListener(this);
        this.manager.add((INotifyingMessageProvider)this.propertyEditor);
    }

    protected void createButtons(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        JFaceColors.setColors((Control)buttonGroup, (Color)parent.getForeground(), (Color)parent.getBackground());
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        buttonGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        Composite midSpacer = new Composite(buttonGroup, 0);
        data = new GridData(4, 0, true, false);
        data.heightHint = 0;
        midSpacer.setLayoutData((Object)data);
    }

    public void editProperties() {
        if (this.relProxy.getProperties().isEmpty()) {
            return;
        }
        IProperty element = this.relProxy.getProperties().get(0);
        this.propertyEditor.getTableViewer().editElement((Object)element, 1);
    }

    public void editRelation(IDesc desc, IStoryData data) {
        Object object = this.descBeingEdited = RelationRep.getInstance().isType((IHasRep)desc) ? desc : null;
        if (this.descBeingEdited != null) {
            AdjunctProxy adjProxy;
            IRelation r = (IRelation)desc.getData();
            for (IAdjunct adj : r.getLexicalMarker().getAdjuncts()) {
                adjProxy = AdjunctProxy.convert(adj, data);
                this.relProxy.getLexicalMarker().adjuncts.add(adjProxy);
            }
            int i = 0;
            while (i < r.getArguments().size()) {
                IArgument arg = (IArgument)r.getArguments().get(i);
                ArgumentProxy proxy = i == 0 ? this.relProxy.getArgumentOne() : (i == 1 ? this.relProxy.getArgumentTwo() : new ArgumentProxy());
                for (IAdjunct adj : arg.getAdjuncts()) {
                    adjProxy = AdjunctProxy.convert(adj, data);
                    proxy.adjuncts.add(adjProxy);
                }
                ++i;
            }
            this.relProxy.getProperties().clear();
            this.relProxy.getProperties().addAll(Property.copy((Collection)r.getProperties()));
        }
        this.updateControls();
    }

    public String captureSelection() {
        IHasPosition selection = this.editor.getSelectedRange();
        IDescSet tokenDescs = this.editor.getStoryModel().getData().getDescriptions(TokenRep.getInstance());
        if ((tokenDescs = tokenDescs.openSet(selection)).isEmpty()) {
            tokenDescs = tokenDescs.closedSet(selection);
        }
        if (tokenDescs.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator i = tokenDescs.iterator();
        while (i.hasNext()) {
            IToken token = (IToken)((IDesc)i.next()).getData();
            result.append(token.getSurface());
            if (!i.hasNext()) continue;
            result.append(space);
        }
        return result.toString();
    }

    public void clear() {
        this.descBeingEdited = null;
        this.relProxy.clear();
        this.viewer.setInput(null);
        this.propertyEditor.setInput(null);
        this.updateControls();
    }

    public boolean isCleared() {
        boolean result = this.descBeingEdited == null;
        result &= this.propertyEditor.isCleared();
        return result &= this.relProxy.isSet();
    }

    public void showAll() {
    }

    public void hideAll() {
    }

    public boolean isShowingAll() {
        return false;
    }

    public boolean isHidingAll() {
        return false;
    }

    public void setMessage(String msg, int type) {
    }

    public String getMessage() {
        return this.manager.getMessage();
    }

    public int getMessageType() {
        return this.manager.getMessageType();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.updateControls();
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }

    public void propertiesModified(PropertyModifyEvent e) {
        this.updateControls();
    }

    public void removeAnnotations() {
    }

    protected void updateControls() {
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.pListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.pListeners.remove((Object)listener);
    }

    protected void notifyPropertyChangeListeners(PropertyChangeEvent event) {
        Object[] objectArray = this.pListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    public LexicalMarkerCaptureWidget<?> getLexicalMarkerWidget() {
        return this.lmWidget;
    }

    public SegmentSetCaptureWidget<?> getArgumentOneWidget() {
        return this.argOneWidget;
    }

    public SegmentSetCaptureWidget<?> getArgumentTwoWidget() {
        return this.argTwoWidget;
    }

    public SegmentSetCaptureWidget<?> getAdditionalWidget() {
        return this.addWidget;
    }

    public boolean createRelation() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClearSynchronizer
    implements IPropertyChangeListener {
        Control control;
        AnnotationWidget<?> widget;
        LexicalMarkerCaptureWidget<?> widget2;

        public ClearSynchronizer(Control control, AnnotationWidget<?> widget) {
            this.control = control;
            this.widget = widget;
            this.widget2 = widget instanceof LexicalMarkerCaptureWidget ? (LexicalMarkerCaptureWidget)widget : null;
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    protected class EditableRelationViewer
    extends RelationViewer {
        IAction deleteAction;
        IAction toggleAction;

        public EditableRelationViewer(Composite parent, int style, int align) {
            super(parent, style, align);
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            TreeViewer viewer = super.createTreeViewer(parent);
            this.deleteAction = new DeleteRelationPartAction();
            this.deleteAction.setEnabled(false);
            this.toggleAction = new ToggleMakeReferentAction();
            this.toggleAction.setEnabled(false);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    boolean enable;
                    ISelection s = event.getSelection();
                    AdjunctProxy a = (AdjunctProxy)SelectionUtils.extractSingle((ISelection)s, AdjunctProxy.class);
                    boolean bl = enable = a != null;
                    if (a == ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.getLexicalMarker()) {
                        enable = false;
                    }
                    if (a == ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.getArgumentOne()) {
                        enable = false;
                    }
                    if (a == ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.getArgumentTwo()) {
                        enable = false;
                    }
                    if (EditableRelationViewer.this.deleteAction != null) {
                        EditableRelationViewer.this.deleteAction.setEnabled(enable);
                    }
                    if (EditableRelationViewer.this.toggleAction != null) {
                        EditableRelationViewer.this.toggleAction.setEnabled(enable);
                    }
                }
            });
            MenuManager m = new MenuManager();
            m.add((IContributionItem)new Separator("group.edit"));
            m.appendToGroup("group.edit", this.deleteAction);
            m.appendToGroup("group.edit", this.toggleAction);
            viewer.getTree().setMenu(m.createContextMenu((Control)viewer.getTree()));
            return viewer;
        }

        protected class DeleteRelationPartAction
        extends DeleteAction {
            protected DeleteRelationPartAction() {
            }

            protected void doDelete() {
                ISelection s = EditableRelationViewer.this.getTreeViewer().getSelection();
                IAdjunct target = (IAdjunct)SelectionUtils.extractSingle((ISelection)s, IAdjunct.class);
                if (target == null) {
                    return;
                }
                if (target != ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.lexMarker && target != ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.argOne && target != ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.argTwo) {
                    Iterator<Object> i;
                    boolean looking = true;
                    if (looking) {
                        i = ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.lexMarker.adjuncts.iterator();
                        while (i.hasNext()) {
                            if (target != i.next()) continue;
                            i.remove();
                            looking = false;
                            break;
                        }
                    }
                    if (looking) {
                        i = ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.argOne.adjuncts.iterator();
                        while (i.hasNext()) {
                            if (target != i.next()) continue;
                            i.remove();
                            looking = false;
                            break;
                        }
                    }
                    if (looking) {
                        i = ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.argTwo.adjuncts.iterator();
                        while (i.hasNext()) {
                            if (target != i.next()) continue;
                            i.remove();
                            looking = false;
                            break;
                        }
                    }
                    if (looking) {
                        Iterator<ArgumentProxy> i2 = ((EditableRelationViewer)EditableRelationViewer.this).RelationCreatorWidget.this.relProxy.additionalArgs.iterator();
                        block3: while (i2.hasNext()) {
                            ArgumentProxy arg = i2.next();
                            if (arg == target) {
                                i2.remove();
                                looking = false;
                                break;
                            }
                            Iterator<AdjunctProxy> j = arg.adjuncts.iterator();
                            while (j.hasNext()) {
                                if (target != j.next()) continue;
                                j.remove();
                                looking = false;
                                continue block3;
                            }
                        }
                    }
                    RelationCreatorWidget.this.updateControls();
                }
            }
        }

        protected class ToggleMakeReferentAction
        extends ResourceAction2 {
            public ToggleMakeReferentAction() {
                super(DiscourseUIMessages.getBundle(), DiscourseUIMessages.ACTION_ToggleMakeReferent_prefix);
            }

            public void run() {
                ISelection s = EditableRelationViewer.this.getTreeViewer().getSelection();
                AdjunctProxy target = (AdjunctProxy)SelectionUtils.extractSingle((ISelection)s, AdjunctProxy.class);
                if (target == null) {
                    return;
                }
                target.setMakeReferent(!target.shouldMakeReferent());
                RelationCreatorWidget.this.updateControls();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HasProperties
    implements IHasProperties,
    IClearable {
        private final List<IProperty> props = new ArrayList<IProperty>();

        protected HasProperties() {
        }

        public List<IProperty> getProperties() {
            return this.props;
        }

        public void clear() {
            this.props.clear();
        }

        public boolean isCleared() {
            return this.props.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RelationPropertyEditor
    extends PropertyEditor<IHasProperties>
    implements INotifyingMessageProvider,
    IClearable {
        private final ChangeNotifier notifier;
        IRelPropManager m;

        public RelationPropertyEditor(Composite parent, int style, boolean useWorkingCopy) {
            super(parent, style, useWorkingCopy);
            this.notifier = new ChangeNotifier();
            this.m = DiscourseUIPlugin.getDefault().getRelPropManager();
        }

        public void setEditingSupport() {
            this.keyColumn.setEditingSupport((EditingSupport)new RelPropNameEditingSupport((ColumnViewer)this.getTableViewer()));
            this.valueColumn.setEditingSupport((EditingSupport)new RelPropValueEditingSupport((ColumnViewer)this.getTableViewer()));
        }

        protected IProperty makeNewProperty() {
            String value;
            String name = DiscourseUIPlugin.getDefault().getPluginPreferences().getString("NewRelationAttributeDefaultName");
            if (StringUtils.isEmpty((String)name)) {
                name = "defaultName";
            }
            if (StringUtils.isEmpty((String)(value = DiscourseUIPlugin.getDefault().getPluginPreferences().getString("NewRelationAttributeDefaultValue")))) {
                value = "";
            }
            return new Property(name, value);
        }

        public boolean validate() {
            if (this.getInput() == null) {
                return false;
            }
            for (IProperty p : this.getProperties()) {
                if (!StringUtils.isEmpty((String)((String)p.getValue()))) continue;
                return false;
            }
            return true;
        }

        public String getMessage() {
            return this.validate() ? "" : "Property value not set";
        }

        public int getMessageType() {
            return this.validate() ? 0 : 3;
        }

        public void notifyChangeListeners(Object source) {
            this.notifier.notifyChangeListeners(source);
        }

        public void allowNotifications() {
            this.notifier.allowNotifications();
        }

        public void suppressNotifications() {
            this.notifier.suppressNotifications();
        }

        public void addChangeListener(ChangeListener listener) {
            this.notifier.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.notifier.removeChangeListener(listener);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected abstract class RelPropEditingSupport
        extends EditingSupport {
            protected String[] emptyStringArray;
            protected Object currentElement;
            protected TextCellEditor textEditor;
            protected ComboBoxCellEditor comboEditor;

            public RelPropEditingSupport(ColumnViewer viewer) {
                super(viewer);
                this.emptyStringArray = new String[0];
                this.textEditor = new TextCellEditor(this.getCellEditorParent());
                this.textEditor.getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (RelPropEditingSupport.this.currentElement == null || e.character != '\t') {
                            return;
                        }
                        Object value = RelPropEditingSupport.this.textEditor.getValue();
                        Object element = RelPropEditingSupport.this.currentElement;
                        RelPropEditingSupport.this.setValue(RelPropEditingSupport.this.currentElement, value);
                        RelPropEditingSupport.this.textEditor.deactivate();
                        if (RelationPropertyEditor.this.getTableViewer().getInput() instanceof IHasProperties) {
                            IHasProperties hp = (IHasProperties)RelationPropertyEditor.this.getTableViewer().getInput();
                            List ps = hp.getProperties();
                            int i = ps.indexOf(element);
                            if (++i < 0 || i == ps.size()) {
                                return;
                            }
                            RelationPropertyEditor.this.getTableViewer().editElement(ps.get(i), 1);
                            e.doit = false;
                        }
                    }
                });
                this.comboEditor = new ComboBoxCellEditor(this.getCellEditorParent(), this.emptyStringArray);
                this.comboEditor.getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (RelPropEditingSupport.this.currentElement == null || e.character != '\t') {
                            return;
                        }
                        Object element = RelPropEditingSupport.this.currentElement;
                        Object value = RelPropEditingSupport.this.comboEditor.getValue();
                        RelPropEditingSupport.this.setValue(RelPropEditingSupport.this.currentElement, value);
                        RelPropEditingSupport.this.comboEditor.deactivate();
                        if (RelationPropertyEditor.this.getTableViewer().getInput() instanceof List) {
                            List ps = (List)RelationPropertyEditor.this.getTableViewer().getInput();
                            int i = ps.indexOf(element);
                            if (++i < 0 || i == ps.size()) {
                                return;
                            }
                            RelationPropertyEditor.this.getTableViewer().editElement(ps.get(i), 1);
                            e.doit = false;
                        }
                    }
                });
            }

            protected Composite getCellEditorParent() {
                return (Composite)this.getViewer().getControl();
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                this.currentElement = element;
                IProperty p = (IProperty)element;
                String[] choices = this.comboEditor.getItems();
                if (choices.length > 0) {
                    int i = Arrays.asList(choices).indexOf(this.getCurrent(p));
                    return i == -1 ? 0 : Integer.valueOf(i);
                }
                return this.getCurrent(p);
            }

            protected CellEditor getCellEditor(Object element) {
                IProperty p = (IProperty)element;
                List<String> options = this.getOptions(p);
                if (options == null || options.size() == 0) {
                    this.comboEditor.setItems(this.emptyStringArray);
                    this.textEditor.setValue((Object)this.getCurrent(p));
                    return this.textEditor;
                }
                String curr = this.getCurrent(p);
                if (!StringUtils.isEmpty((String)curr) && !options.contains(curr)) {
                    options.add(0, curr);
                }
                this.comboEditor.setItems(options.toArray(new String[options.size()]));
                return this.comboEditor;
            }

            protected abstract List<String> getOptions(IProperty var1);

            protected abstract String getCurrent(IProperty var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class RelPropNameEditingSupport
        extends RelPropEditingSupport {
            public RelPropNameEditingSupport(ColumnViewer viewer) {
                super(viewer);
            }

            @Override
            protected String getCurrent(IProperty p) {
                return (String)p.getKey();
            }

            @Override
            protected List<String> getOptions(IProperty p) {
                return RelationPropertyEditor.this.m.getDropdownProperties(((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.relProxy);
            }

            protected void setValue(Object element, Object value) {
                this.currentElement = null;
                if (!IProperty.class.isAssignableFrom(element.getClass())) {
                    return;
                }
                IProperty p = (IProperty)element;
                if (value instanceof Integer) {
                    Integer comboIdx = (Integer)value;
                    CCombo combo = (CCombo)this.comboEditor.getControl();
                    if (comboIdx == -1) {
                        String freetext = combo.getText();
                        p.setKey(freetext);
                    } else {
                        String item = combo.getItem(comboIdx.intValue());
                        p.setKey(item);
                    }
                } else if (value instanceof String) {
                    p.setKey((String)value);
                }
                this.getViewer().refresh();
                ((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.manager.notifyChangeListeners((Object)((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.propertyEditor);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class RelPropValueEditingSupport
        extends RelPropEditingSupport {
            public RelPropValueEditingSupport(ColumnViewer viewer) {
                super(viewer);
            }

            @Override
            protected String getCurrent(IProperty p) {
                return (String)p.getValue();
            }

            @Override
            protected List<String> getOptions(IProperty p) {
                return RelationPropertyEditor.this.m.getOptions(p, ((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.relProxy.getProperties());
            }

            protected void setValue(Object element, Object value) {
                this.currentElement = null;
                if (!IProperty.class.isAssignableFrom(element.getClass())) {
                    return;
                }
                IProperty p = (IProperty)element;
                if (value instanceof Integer) {
                    Integer comboIdx = (Integer)value;
                    CCombo combo = (CCombo)this.comboEditor.getControl();
                    if (comboIdx == -1) {
                        String freetext = combo.getText();
                        p.setValue((Object)freetext);
                    } else {
                        String item = combo.getItem(comboIdx.intValue());
                        p.setValue((Object)item);
                    }
                    List<String> results = RelationPropertyEditor.this.m.getResults(p, ((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.relProxy.getProperties());
                    if (results != null && !results.isEmpty()) {
                        int propIdx = ((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.relProxy.getProperties().indexOf(p);
                        for (String result : results) {
                            ((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.relProxy.getProperties().add(++propIdx, (IProperty)new Property(result, ""));
                        }
                    }
                } else if (value instanceof String) {
                    p.setValue((Object)((String)value));
                }
                this.getViewer().refresh();
                ((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.manager.notifyChangeListeners((Object)((RelationPropertyEditor)RelationPropertyEditor.this).RelationCreatorWidget.this.propertyEditor);
            }
        }
    }
}

