/* Filename: ReferenceRep.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 18/09/2009
 */
package nil.ucm.indications2.core.rep;

import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;

/** 
 *   Representation for the references in a text. This representation is different from the internal 
 * Reference class used by the ReferentRep in edu.mit.discourse. This representation will store more
 * information about the references: type, nucleus and modifiers, and the referent/reference it
 * corresponds to. 
 *
 * @author Raquel Hervas
 * @version 1.00, (Sep 18, 2009)
 * @since nil.ucm.reference.core 1.0.0
 */
public class IndicationStructureRep extends AbstractRep {
	
	public static final String ID = "nil.ucm.indications2.indicationStructure";
	
	private static final long serialVersionUID = 1L;
	
	private static IRep fInstance = null;
	
	public static IRep getInstance(){
		if(fInstance == null) fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);  
		return fInstance;
	}

	public IndicationStructureRep() {
		super(IIndicationStructure.class, 1); 
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.AbstractRep#initAntecedentsInternal(edu.mit.story.core.rep.IRepSet)
	 */
	@Override
	protected void initAntecedentsInternal(IRepSet container) {
		container.add(ReferentRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#reconstitute(edu.mit.story.core.position.IHasPosition, java.lang.String, edu.mit.story.core.model.IStoryModel)
	 */
	public IndicationStructure reconstitute(IHasPosition p, String description, IStoryModel model) {
		return IndicationStructure.reconstitute(description, model.getData());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#serialize(java.lang.Object)
	 */
	public String serialize(IData data) {
		IIndicationStructure is = (IIndicationStructure)data;
		return IndicationStructure.serialize(is);
	}

}
