/* Filename: RefExpTranslationFactory.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package nil.ucm.indications2.core.rep.indication;

import java.util.LinkedList;
import java.util.List;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.indication.Indication.ConstituentBuilder;
import nil.ucm.indications2.core.rep.indication.Indication.IConstituentBuilder;
import edu.mit.discourse.core.rep.coref.CorefTranslationFactory;
import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class IndicationTranslationFactory extends AbstractDescFactory2<IndexedIndication> {
	
	public static final String ID = "es.ucm.nil.indication.rep.indication.factory.translation";

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @param requiredRep
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public IndicationTranslationFactory() {
		super(IndicationRep.getInstance(), IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.factory.AbstractDescFactory2#calculateRegions(edu.mit.story.core.model.change.StoryChangeEvent)
	 */
	@Override
	protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
		// this factory is not intended to generate any data
		return null;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.factory.AbstractDescFactory2#calculateData(edu.mit.story.core.position.IHasPosition, edu.mit.story.core.model.IStoryModel)
	 */
	@Override
	protected IHasPositionSet<IndexedIndication> calculateData(IHasPosition region, IStoryModel model) {
		
		if(!model.supports(IndicationStructureRep.getInstance()))
			return null;
		
		 IHasPositionSet<IndexedIndication> result = new HasPositionSet<IndexedIndication>();

		IDescSet indDescs = model.getData().getDescriptions(IndicationStructureRep.getInstance()).openSet(region);
		IIndicationStructure indStruct; 
		IIndication ind;
		for(IDesc indDesc : indDescs){
			indStruct = (IIndicationStructure)indDesc.getData();
			ind = toIndication(indStruct, model);
			if(ind != null)
				result.add(new IndexedIndication(ind));
		}
		return result;
	}
	
	/**
	 * TODO: Write comment
	 *
	 * @param indStruct
	 * @param model
	 * @return
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	protected IIndication toIndication(IIndicationStructure indStruct, IStoryModel model){
		
		// first get referring expression
		IReference r = indStruct.getReference();
		IDescSet refexps = model.getData().getDescriptions(RefExpRep.getInstance()).openSet(r);
		IDesc refexp = CorefTranslationFactory.getReferringExpression(r, refexps);
		
		// make builders
		List<IConstituentBuilder> builders = new LinkedList<IConstituentBuilder>();
		IConstituentBuilder builder;
		IndicationType type;
		for(INucleus nuc : indStruct.getNuclei()){
			type = getType(nuc.getType());
			builder = new ConstituentBuilder(true, type, new SegmentSet(nuc.getSegments()));
			builders.add(builder);
		}
		for(IModifier mod : indStruct.getModifiers()){
			type = getType(mod.getType());
			builder = new ConstituentBuilder(false, type, new SegmentSet(mod.getSegments()));
			builders.add(builder);
		}
		
		return new Indication(refexp, builders);
	}
	
	protected IndicationType getType(IHasDescription type){
		for(IndicationType e : IndicationType.values())
			if(e.getName().equals(type.getDescription()))
				return e;
		return null;
	}

}
