/* Filename: ReferenceModel.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 21, 2010
 */
package nil.ucm.indications2.core.rep.model;

import org.eclipse.jface.dialogs.IMessageProvider;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.Message;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class ReferenceModel extends AbstractViewModel implements IReferenceModel, IModelListener {
	
	public static final Message noRefErr = new Message("A reference must be selected", ERROR); 
	
	private final IStoryModel storyModel;
	private IDesc referentDesc;
	private IReference reference;
	
	public ReferenceModel(IStoryModel model){
		if(model == null) throw new NullPointerException();
		this.storyModel = model;
		storyModel.addModelListener(this);
	}
	
	public IStoryModel getStoryModel(){
		return storyModel;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.models.IReferenceModel#getReference()
	 */
	public IReference getReference() {
		return reference;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.models.IReferenceModel#getReferentDescription()
	 */
	public IDesc getReferentDescription() {
		return referentDesc;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.models.IReferenceModel#setReference(edu.mit.story.core.desc.IDesc, int)
	 */
	public void setReference(IDesc referentDesc, int refID) {
		if(referentDesc == null) throw new NullPointerException();
		if(!ReferentRep.getInstance().isType(referentDesc)) throw new IllegalArgumentException();
		IReferent r = (IReferent)referentDesc.getData();
		IReference ref = r.getReference(refID);
		if(ref == null) throw new IllegalArgumentException();
		this.referentDesc = referentDesc;
		this.reference = ref;
		setOutOfSync();
		notifyChangeListeners();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.referent.IReference#getID()
	 */
	public int getID() {
		return reference == null ? -1 : reference.getID();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.referent.IReference#getParent()
	 */
	public IReferent getParent() {
		return reference == null ? null : reference.getParent();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.referent.IReference#getSegments()
	 */
	public ISegmentSet getSegments() {
		return reference == null ? null : reference.getExpression();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getLength()
	 */
	public int getLength() {
		return reference == null ? -1 : reference.getLength();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getOffset()
	 */
	public int getOffset() {
		return reference == null ? -1 : reference.getOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getRightOffset()
	 */
	public int getRightOffset() {
		return reference == null ? -1 : reference.getRightOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IHasDisplayText#getDisplayText()
	 */
	public String getDisplayText() {
		return reference == null ? "": reference.getDisplayText();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.ui.models.AbstractViewModel#internalClear()
	 */
	protected void internalClear() {
		referentDesc = null;
		reference = null;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IClearable#isCleared()
	 */
	public boolean isCleared() {
		return referentDesc == null;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.NotifyingMessageProvider#calculateMessage()
	 */
	@Override
	protected IMessageProvider calculateMessage() {
		return isCleared() ? noRefErr : Message.NO_MESSAGE;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IDisposable#dispose()
	 */
	public void dispose() {
		storyModel.removeModelListener(this);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.IModelListener#modelChanged(edu.mit.story.core.model.change.StoryChangeEvent)
	 */
	public void modelChanged(StoryChangeEvent e) {
		if(referentDesc == null) return;
		if(!e.affects(ReferentRep.getInstance())) return;
		IDesc newDesc = e.getModel().getData().getDescriptions(ReferentRep.getInstance()).getDescription(referentDesc.getID());
		if(referentDesc == newDesc) return;
		IReferent r = (newDesc == null) ? null : (IReferent)newDesc.getData();
		IReference ref = (r == null) ? null : r.getReference(reference.getID());
		
		if(ref == null){
			clear();
		} else {
			setReference(newDesc, reference.getID());
		}
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IHasRep#getRep()
	 */
	public IRep getRep() {
		return getSegments().first().getRep();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.referent.IReference#getExpression()
	 */
	public ISegmentSet getExpression() {
		return getSegments();
	}

}
