/* Filename: OneIndicationPerRefRule.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 27, 2010
 */
package nil.ucm.indications2.core.rep.rules;

import java.util.HashSet;
import java.util.Set;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.problems.SubReferenceBrokenProblem;
import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class SubReferencesUnbrokenRule extends AbstractBuildRule {
	
	public static final String ID = SubReferencesUnbrokenRule.class.getCanonicalName();

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public SubReferencesUnbrokenRule() {
		super(IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		IDescSet refDescs = model.getData().getDescriptions(ReferentRep.getInstance());
		IDescSet indDescs = model.getData().getDescriptions(IndicationStructureRep.getInstance());
		
		Set<IDesc> problems = new HashSet<IDesc>();
		
		IReferent referent;
		IIndicationStructure is;
		Set<IDesc> refTokens, indTokens;
		for(IDesc refDesc : refDescs){
			referent = (IReferent)refDesc.getData();
			for(IReference reference : referent.getReferences()){
				refTokens = Segment.extractSegmentDescriptions(reference);
				
				// find indications that overlap this reference
				inner:for(IDesc indDesc : indDescs.closedSet(reference)){
					is = (IIndicationStructure)indDesc.getData();
					indTokens = Segment.extractSegmentDescriptions(is.getReference());
					
					// ignore the indication that corresponds to this reference
					if(is.getReference() == reference) continue;
					
					// ignore indications that don't complete subsume the reference
					if(!indTokens.containsAll(refTokens)) continue;
					
					// the reference must be completely subsumed by 
					// a nucleus or a modifier
					for(INucleus n : is.getNuclei()){
						for(ISegment s : n.getSegments()){
							if(s.getDescs().containsAll(refTokens)) continue inner;
						}
					}
					for(IModifier m : is.getModifiers()){
						for(ISegment s : m.getSegments()){
							if(s.getDescs().containsAll(refTokens)) continue inner;
						}
					}
					problems.add(indDesc);
				}
			}
		}
		
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		if(isCompressing()){
			if(!problems.isEmpty()) result.add(new SubReferenceBrokenProblem(problems, ID));
		} else {
			for(IDesc problem : problems) result.add(new SubReferenceBrokenProblem(problem, ID));
		}
		return result;
	}
	
}
