/* Filename: AmbiguousSenseProblem.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Nov 1, 2009
 */
package edu.mit.discourse.core.rep.coref.problems;

import java.util.Collections;

import org.eclipse.core.resources.IMarker;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since StoryWorkbench 1.0
 */
public class UnusedRefexpProblem extends StoryProblem {
	
	public static final String ID = "edu.mit.parsing.core.problem.unusedRefexp";

	/**
	 * TODO: Write comment
	 *
	 * @since StoryWorkbench 1.0
	 */
	public UnusedRefexpProblem(IDesc refexp, String buildRuleID) {
		super(POSRep.getInstance(), buildRuleID);
		setID(ID);
		setName("Unused Referring Expression");
		setDescs(Collections.singleton(refexp));
		setSeverity(IMarker.SEVERITY_ERROR);
		
		IDescSet refexps = getDescs().getDescriptions(RefExpRep.getInstance());
		if(refexps.size() != 1)
			throw new IllegalArgumentException();

		IDesc d = refexps.first();
		setPosition(d);
		
		IRefExp re = (IRefExp)d.getData();
		StringBuilder sb = new StringBuilder();
		sb.append("The referring expression '");
		sb.append(re.getDisplayText());
		sb.append("' is not used in any coreference relationship");
		setDescription(sb.toString());
	}

}
