/* Filename: IEntity.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Jan 17, 2008
 */
package edu.mit.discourse.core.rep.referent;

import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;

/**
 * A referent is a collection references that are interpreted to all refer to
 * the same thing. The referent can be anything that can be referred to in
 * discourse, for example, a person, place, thing, idea, concept,
 * implicitly-mentioned set of objects, and so on. A referent has a name for
 * ease of identification.
 * 
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public interface IReferent extends IHasPosition, IStructuredData {

	/**
	 * Returns the name of this referent, used for easy identification. The name
	 * should not be <code>null</code>, empty, or all-whitespace.
	 * 
	 * @return the non-null, non-empty name of this referent
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public String getName();
	
	/**
	 * Returns the set of references to this referent. This set should never be
	 * <code>null</code> or empty.
	 * 
	 * @return the set of references to this referent.
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public IHasPositionSet<IReference> getReferences();

	/**
	 * Returns the reference to this reference with the specified id. If there
	 * is no such reference, this method returns <code>null</code>.
	 * 
	 * @param id
	 *            the id for the reference requested
	 * @return the reference matching the specified id, or <code>null</code> if
	 *         there is none
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public IReference getReference(int id);
		
}
