/* Filename: ReferentProperty.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 23, 2009
 */
package edu.mit.discourse.core.rep.refprops;

import java.util.Collection;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IRep;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class ReferentProperty implements IReferentProperty {
	
	// instance fields, final
	private final PropertyType type;
	private final IDesc refexp;
	private final ISegmentSet segments;
	private final IHasPosition position;

	/**
	 * TODO: Write comment
	 * 
	 * @param referent
	 * @param property
	 * @throws NullPointerException if either the description or collection of segments in <code>null</code>
	 * @throws IllegalArgumentException
	 *             if the specified description is not of the
	 *             <code>ReferentRep</code> type, the collection of segments is
	 *             empty, or any segment in the collection is not of the
	 *             <code>TokenRep</code> type
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public ReferentProperty(PropertyType type, IDesc refexp, Collection<? extends ISegment> property){
		
		// check and assign referent
		if(type == null)
			throw new NullPointerException();
		if(refexp == null) 
			throw new NullPointerException();
		if(!RefExpRep.getInstance().isType(refexp)) 
			throw new IllegalArgumentException();
		
		this.type = type;
		this.refexp = refexp;
		
		// check as assign segments
		ISegmentSet segs = new SegmentSet(property);
		if(!TokenRep.getInstance().isType(segs))
			throw new IllegalArgumentException();
		this.segments = segs;

		// calculate position
		position = PositionUtils.combine(refexp, this.segments);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.IReferentProperty#getReferent()
	 */
	
	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.IReferentProperty#getType()
	 */
	public PropertyType getType() {
		return type;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IHasRep#getRep()
	 */
	public IRep getRep() {
		return segments.getRep();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IHasDisplayText#getDisplayText()
	 */
	public String getDisplayText() {
		return segments.getDisplayText();
	}

	public IDesc getReferringExpression() {
		return refexp;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.IReferentProperty#getSegments()
	 */
	public ISegmentSet getExtent() {
		return segments;
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	
	public IHasPosition getDisplayPosition() {
		return PositionUtils.makePosition(segments);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	
	public IHasPosition calculatePosition() {
		return position;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.model.IStoryModel)
	 */
	
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		
		// see if referent has changed
		IDesc newRefExp = model.getData().getDescriptions(RefExpRep.getInstance()).getDescription(refexp.getID());
		boolean changed = (newRefExp != refexp); 
		
		ISegmentSet newSegments = (ISegmentSet)segments.recalculate(container, model);
		changed |= (newSegments != segments);
		
		if(!changed) 
			return this;
		
		if(newRefExp == null || newSegments.isEmpty()) 
			return null;
		
		return new ReferentProperty(type, newRefExp, newSegments);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		
		if(this == tgtData)
			return true;
		if(!IReferentProperty.class.isAssignableFrom(tgtData.getClass()))
			return false;
		IReferentProperty tgtProp = (IReferentProperty)tgtData;
		
		if(type != tgtProp.getType())
			return false;
		if(!refexp.equals(tgtProp.getReferringExpression(), model))
			return false;
		if(!segments.equals(tgtProp.getExtent(), model))
			return false;
		return true;
	}

}
