/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.core.util.WordInfo;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import edu.mit.wordnet.core.WordnetMessages;
import edu.mit.wordnet.core.WordnetPlugin;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.IndexedSense;
import edu.mit.wordnet.core.rep.sense.Sense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.algorithm.ISenseTagger;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenseDescFactory
extends AbstractDescFactory2<IndexedSense> {
    IExtendedDictionary fDict;
    ISenseTagger fTagger;

    public SenseDescFactory() {
        super(SenseRep.getInstance(), new IRep[]{TokenRep.getInstance(), CollocRep.getInstance(), POSRep.getInstance(), StemRep.getInstance()});
    }

    protected boolean doInit(IStoryModel model) {
        this.fDict = SenseRep.getDictionary(model.getData());
        if (this.fDict == null) {
            return false;
        }
        String taggerID = (String)this.getConfiguration().get((Object)"senseTagger");
        if (taggerID == null) {
            return false;
        }
        this.fTagger = (ISenseTagger)WordnetPlugin.getDefault().getSenseTaggerManager().create(taggerID);
        if (this.fTagger == null) {
            return false;
        }
        this.fTagger.setDictionary(this.fDict);
        this.fTagger.init();
        return true;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        Change c1 = event.getChange(TokenRep.getInstance());
        Change c2 = event.getChange(CollocRep.getInstance());
        Change c3 = event.getChange(POSRep.getInstance());
        Change c4 = event.getChange(StemRep.getInstance());
        if (c1 == null && c2 == null && c3 == null && c4 == null) {
            return null;
        }
        HasPositionSet regions = new HasPositionSet();
        if (c1 != null) {
            regions.addAll((Collection)c1.getChanges());
        }
        if (c2 != null) {
            regions.addAll((Collection)c2.getChanges());
        }
        if (c3 != null) {
            regions.addAll((Collection)c3.getChanges());
        }
        if (c4 != null) {
            regions.addAll((Collection)c4.getChanges());
        }
        IntervalSet result = new IntervalSet();
        IDescSet ds = event.provider.getData().getDescriptions(TokenRep.getInstance());
        for (IHasPosition region : regions) {
            result.addAll((Collection)ds.openSet(region));
        }
        ds = event.provider.getData().getDescriptions(CollocRep.getInstance());
        for (IHasPosition region : regions) {
            result.addAll((Collection)ds.openSet(region));
        }
        return result;
    }

    protected IHasPositionSet<IndexedSense> calculateData(IHasPosition region, IStoryModel model) {
        IDescSet tokens = model.getData().getDescriptions(TokenRep.getInstance());
        HasPositionSet result = new HasPositionSet();
        for (IDesc token : tokens.openSet(region)) {
            WordInfo info = WordInfo.extract((IDesc)token, (IStoryModel)model);
            IPosTag posTag = info.getPosTag();
            if (posTag == null || posTag.isAuxiliary()) continue;
            for (ISenseAssignment sa : this.fTagger.tag((IBaseWordInfo)info)) {
                Sense s = new Sense(info.getDesc(), info.getStemDesc(), info.getPOSDesc(), sa.getSense(), sa.getEvidence());
                result.add((Object)new IndexedSense((IHasPosition)token, s));
            }
        }
        return result;
    }

    protected IDesc toDescription(IndexedSense idxData, IStoryModel model) {
        String data = SenseRep.getInstance().serialize(idxData.getData());
        ISense sense = (ISense)SenseRep.getInstance().reconstitute((IHasPosition)idxData, data, model);
        Desc newDesc = new Desc(model.getNextID(), this.getRep(), (IHasPosition)idxData, (IData)sense, null);
        newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(this.getID(), true)));
        return newDesc;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new SenseFactoryConfigDescriptor(this.getID(), this.getName(), this.getDescription());
    }

    public static class SenseFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public SenseFactoryConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public SenseFactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("senseTagger", WordnetMessages.PARAM_SenseTagger_name, WordnetMessages.PARAM_SenseTagger_desc, (IValidator)new ManagerBackedListValidator((IManager)WordnetPlugin.getDefault().getSenseTaggerManager()), false, "DefaultSenseTaggerID", WordnetPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

