/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.hovers;

import edu.mit.jwi.item.IWord;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.Iterator;

public class SenseHover
extends StoryTextHover {
    public SenseHover() {
        super(SenseRep.getInstance());
    }

    public String getHoverInfo(IStoryModel editor, int hoverOffset, IHasPosition selection) {
        if (!editor.supports(SenseRep.getInstance())) {
            return null;
        }
        IDescSet senseDescs = editor.getData().getDescriptions(SenseRep.getInstance()).closedSet((IHasPosition)new SimplePosition(hoverOffset, 0));
        StringBuilder sb = new StringBuilder();
        sb.append("Senses:\n");
        Iterator i = senseDescs.iterator();
        while (i.hasNext()) {
            ISense sense = (ISense)((IDesc)i.next()).getData();
            IWord word = sense.getSense();
            if (word == null) {
                sb.append("(null)");
            } else {
                sb.append(word.getLemma());
                sb.append(" - ");
                sb.append(word.getSynset().getGloss());
            }
            if (!i.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

