/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Messages;

public class Collect
extends InstallableUnitPhase {
    private static final String PHASE_ID = "collect";

    public Collect(int weight) {
        super(PHASE_ID, weight);
        this.prePerformWork = 0;
        this.mainPerformWork = 100;
        this.postPerformWork = 1000;
    }

    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null;
    }

    protected ProvisioningAction[] getActions(InstallableUnitOperand currentOperand) {
        ProvisioningAction action = Collect.getTouchpoint(currentOperand).getAction(this.phaseId);
        return new ProvisioningAction[]{action};
    }

    protected String getProblemMessage() {
        return Messages.Phase_Collect_Error;
    }

    protected IStatus completeInstallableUnitPhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        List artifactRequests = (List)parameters.get("artifactRequests");
        DownloadManager dm = new DownloadManager(this.provContext);
        Iterator it = artifactRequests.iterator();
        while (it.hasNext()) {
            IArtifactRequest[] requests = (IArtifactRequest[])it.next();
            dm.add(requests);
        }
        return dm.start(monitor);
    }

    protected IStatus initializeInstallableUnitPhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        parameters.put("artifactRequests", new ArrayList());
        return null;
    }
}

