/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.authentication.SSLClientCertificatesMSCapi;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;

public class SSLClientCertificate
extends TrayDialog {
    private String realm;
    private String certificate;
    private String passphrase;
    private boolean save;
    private boolean maySave;
    private boolean msCapi;
    private Button mscapiButton;
    private Combo keyFileCombo;
    private Text passphraseText;
    private Text aliasText;
    private Button browseButton;
    private Button saveButton;
    private Button okButton;
    private Button aliasButton;
    private String alias;
    private String[] keyFiles = new String[0];
    private static int WIDTH = 300;

    public SSLClientCertificate(Shell parentShell, String realm, boolean maySave) {
        super(parentShell);
        this.realm = realm;
        this.maySave = maySave;
        this.keyFiles = SVNUIPlugin.getPlugin().getRepositoryManager().getKeyFilesManager().getPreviousKeyFiles();
    }

    protected Control createDialogArea(Composite parent) {
        Composite rtnGroup = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Policy.bind("SSLPromptDialog.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rtnGroup.setLayout((Layout)layout);
        rtnGroup.setLayoutData((Object)new GridData(32));
        Label realmLabel = new Label(rtnGroup, 0);
        realmLabel.setText(Policy.bind("PasswordPromptDialog.repository"));
        Text realmText = new Text(rtnGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = WIDTH;
        realmText.setLayoutData((Object)gd);
        realmText.setEditable(false);
        realmText.setText(this.realm);
        boolean mscapiSupport = false;
        Provider pjacapi = Security.getProvider("CAPI");
        Provider pmscapi = Security.getProvider("SunMSCAPI");
        if (pmscapi != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass("sun.security.mscapi.NONEwithRSASignature");
            }
            catch (Exception exception) {
                pmscapi = null;
            }
        }
        String svnClientText = "";
        if (SVNProviderPlugin.getPlugin() != null && SVNProviderPlugin.getPlugin().getSVNClientManager() != null) {
            svnClientText = SVNProviderPlugin.getPlugin().getSVNClientManager().getSvnClientInterface();
        }
        if (AbstractClientAdapter.isOsWindows() && (pjacapi != null || pmscapi != null) && "svnkit".equals(svnClientText)) {
            mscapiSupport = true;
            this.mscapiButton = new Button(rtnGroup, 32);
            this.mscapiButton.setText(Policy.bind("SSLClientCertificate.0"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.mscapiButton.setLayoutData((Object)gd);
            SelectionAdapter mscapiSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (SSLClientCertificate.this.mscapiButton.getSelection()) {
                        SSLClientCertificate.this.keyFileCombo.setEnabled(false);
                        SSLClientCertificate.this.browseButton.setEnabled(false);
                        SSLClientCertificate.this.passphraseText.setEnabled(false);
                        SSLClientCertificate.this.aliasButton.setEnabled(true);
                    } else {
                        SSLClientCertificate.this.keyFileCombo.setEnabled(true);
                        SSLClientCertificate.this.browseButton.setEnabled(true);
                        SSLClientCertificate.this.passphraseText.setEnabled(true);
                        SSLClientCertificate.this.aliasButton.setEnabled(false);
                        SSLClientCertificate.this.aliasText.setText("");
                    }
                }
            };
            this.mscapiButton.addSelectionListener((SelectionListener)mscapiSelectionListener);
            Label aliasLabel = new Label(rtnGroup, 0);
            aliasLabel.setText(Policy.bind("SSLClientCertificate.1"));
            Composite ailiasSelectGroup = new Composite(rtnGroup, 0);
            GridLayout aliasLayout = new GridLayout();
            aliasLayout.numColumns = 2;
            aliasLayout.marginWidth = 0;
            aliasLayout.marginHeight = 0;
            ailiasSelectGroup.setLayout((Layout)aliasLayout);
            gd = new GridData(768);
            ailiasSelectGroup.setLayoutData((Object)gd);
            this.aliasText = new Text(ailiasSelectGroup, 2048);
            gd = new GridData();
            gd.widthHint = WIDTH;
            this.aliasText.setLayoutData((Object)gd);
            this.aliasText.setEnabled(false);
            this.aliasButton = new Button(ailiasSelectGroup, 8);
            this.aliasButton.setText(Policy.bind("SSLClientCertificate.2"));
            SelectionAdapter msCapiCertificateSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SSLClientCertificatesMSCapi dialog = new SSLClientCertificatesMSCapi(SVNUIPlugin.getStandardDisplay().getActiveShell(), SSLClientCertificate.this.realm);
                    if (dialog.open() == 0) {
                        SSLClientCertificate.this.aliasText.setText(dialog.getAlias());
                    }
                }
            };
            this.aliasButton.addSelectionListener((SelectionListener)msCapiCertificateSelectionListener);
            this.aliasButton.setEnabled(false);
        }
        Label keyFileLabel = new Label(rtnGroup, 0);
        keyFileLabel.setText(Policy.bind("SSLPromptDialog.certificate"));
        Composite keyFileGroup = new Composite(rtnGroup, 0);
        GridLayout keyFileLayout = new GridLayout();
        keyFileLayout.numColumns = 2;
        keyFileLayout.marginWidth = 0;
        keyFileLayout.marginHeight = 0;
        keyFileGroup.setLayout((Layout)keyFileLayout);
        gd = new GridData(768);
        keyFileGroup.setLayoutData((Object)gd);
        this.keyFileCombo = new Combo(keyFileGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.keyFileCombo.setLayoutData((Object)gd);
        this.keyFileCombo.setEnabled(true);
        boolean msCapiPreselected = false;
        if (mscapiSupport) {
            if (this.keyFiles != null && this.keyFiles.length > 0) {
                if (this.keyFiles[0] != null && this.keyFiles[0].startsWith("MSCAPI")) {
                    msCapiPreselected = true;
                    this.keyFileCombo.setEnabled(false);
                    this.aliasButton.setEnabled(true);
                    this.mscapiButton.setSelection(true);
                    if (this.keyFiles[0].split(";").length > 1) {
                        this.aliasText.setText(this.keyFiles[0].split(";")[1]);
                    }
                }
                boolean textset = false;
                int i = 0;
                while (i < this.keyFiles.length) {
                    if (this.keyFiles[i] == null || !this.keyFiles[i].startsWith("MSCAPI")) {
                        if (!textset) {
                            this.keyFileCombo.setText(this.keyFiles[i]);
                            textset = true;
                        }
                        this.keyFileCombo.add(this.keyFiles[i]);
                    }
                    ++i;
                }
            }
        } else if (this.keyFiles != null && this.keyFiles.length > 0) {
            int i = 0;
            while (i < this.keyFiles.length) {
                this.keyFileCombo.add(this.keyFiles[i]);
                ++i;
            }
            this.keyFileCombo.setText(this.keyFiles[0]);
        }
        this.browseButton = new Button(keyFileGroup, 8);
        this.browseButton.setText(Policy.bind("SSHPromptDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String returnFile;
                Properties properties = System.getProperties();
                String home = (String)properties.get("user.home");
                FileDialog fileDialog = new FileDialog(SSLClientCertificate.this.getShell(), 4096);
                if (home != null) {
                    fileDialog.setFilterPath(home);
                }
                if ((returnFile = fileDialog.open()) != null) {
                    SSLClientCertificate.this.keyFileCombo.setText(returnFile);
                }
            }
        });
        this.browseButton.setEnabled(!msCapiPreselected);
        Label passphraseLabel = new Label(rtnGroup, 0);
        passphraseLabel.setText(Policy.bind("SSHPromptDialog.passphrase"));
        this.passphraseText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.passphraseText.setEchoChar('*');
        this.passphraseText.setLayoutData((Object)gd);
        this.passphraseText.setEnabled(!msCapiPreselected);
        if (this.maySave) {
            this.saveButton = new Button(rtnGroup, 32);
            this.saveButton.setText(Policy.bind("SSHPromptDialog.save"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.saveButton.setLayoutData((Object)gd);
        }
        return rtnGroup;
    }

    public Button createButton(Composite parent, int id, String label, boolean isDefault) {
        Button button = super.createButton(parent, id, label, isDefault);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(true);
        }
        return button;
    }

    protected void okPressed() {
        this.passphrase = this.passphraseText.getText().trim();
        if (this.aliasText != null) {
            this.alias = this.aliasText.getText().trim();
        }
        if (this.mscapiButton != null) {
            this.msCapi = this.mscapiButton.getSelection();
        }
        this.certificate = this.msCapi ? "MSCAPI" + (this.alias != null && !"".equals(this.alias) ? ";" + this.alias : "") : this.keyFileCombo.getText().trim();
        if (this.certificate.length() > 0) {
            SVNUIPlugin.getPlugin().getRepositoryManager().getKeyFilesManager().addKeyFile(this.certificate);
        }
        if (this.maySave) {
            this.save = this.saveButton.getSelection();
        }
        super.okPressed();
    }

    public boolean isSave() {
        return this.save;
    }

    public String getKeyFile() {
        return this.certificate;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean isMSCapi() {
        return this.msCapi;
    }

    public String getAlias() {
        return this.alias;
    }
}

