/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.sync;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class OverlayIcon
extends CompositeImageDescriptor {
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;
    private int[] locations;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;

    public OverlayIcon(Image base, ImageDescriptor[] overlays, int[] locations, Point size) {
        this.base = base;
        this.overlays = overlays;
        this.locations = locations;
        this.size = size;
    }

    protected abstract void drawOverlays(ImageDescriptor[] var1, int[] var2);

    public boolean equals(Object o) {
        if (!(o instanceof OverlayIcon)) {
            return false;
        }
        OverlayIcon other = (OverlayIcon)((Object)o);
        return this.base.equals((Object)other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        int i = 0;
        while (i < this.overlays.length) {
            code ^= this.overlays[i].hashCode();
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base.getImageData(), 0, 0);
        this.drawOverlays(this.overlays, this.locations);
    }

    protected Point getSize() {
        return this.size;
    }
}

