/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ILexFile;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synset
implements ISynset {
    final ISynsetID fID;
    final ILexFile fLexFile;
    final String fGloss;
    final boolean fIsAdjSat;
    final boolean fIsAdjHead;
    final List<ISynsetID> allRelated;
    final Map<IPointer, List<ISynsetID>> synsetMap;
    final List<IWord> fWords;
    private static char zero = (char)48;

    public Synset(ISynsetID id, ILexFile lexFile, boolean isAdjSat, boolean isAdjHead, String gloss, List<IWord> words, Map<IPointer, ? extends List<ISynsetID>> ids) {
        if (id == null || lexFile == null || gloss == null) {
            throw new NullPointerException();
        }
        if (isAdjSat && isAdjHead) {
            throw new IllegalArgumentException();
        }
        if ((isAdjSat || isAdjHead) && lexFile.getNumber() != 0) {
            throw new IllegalArgumentException();
        }
        this.fID = id;
        this.fLexFile = lexFile;
        this.fGloss = gloss;
        this.fIsAdjSat = isAdjSat;
        this.fIsAdjHead = isAdjHead;
        this.fWords = Collections.unmodifiableList(words);
        LinkedHashSet hiddenSet = null;
        HashMap hiddenMap = null;
        if (ids != null) {
            hiddenSet = new LinkedHashSet();
            hiddenMap = new HashMap(ids.size());
            for (Map.Entry<IPointer, ? extends List<ISynsetID>> entry : ids.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                hiddenMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
                hiddenSet.addAll(entry.getValue());
            }
        }
        this.allRelated = hiddenSet != null && !hiddenSet.isEmpty() ? Collections.unmodifiableList(new ArrayList(hiddenSet)) : Collections.emptyList();
        this.synsetMap = hiddenMap != null && !hiddenMap.isEmpty() ? Collections.unmodifiableMap(hiddenMap) : Collections.emptyMap();
    }

    @Override
    public ISynsetID getID() {
        return this.fID;
    }

    @Override
    public int getOffset() {
        return this.fID.getOffset();
    }

    @Override
    public POS getPOS() {
        return this.fID.getPOS();
    }

    @Override
    public int getType() {
        POS pos = this.getPOS();
        if (pos == POS.NOUN) {
            return 1;
        }
        if (pos == POS.VERB) {
            return 2;
        }
        if (pos == POS.ADVERB) {
            return 4;
        }
        return this.isAdjectiveSatellite() ? 5 : 3;
    }

    @Override
    public String getGloss() {
        return this.fGloss;
    }

    @Override
    public List<IWord> getWords() {
        return this.fWords;
    }

    @Override
    public IWord getWord(int wordNumber) {
        return this.fWords.get(wordNumber - 1);
    }

    @Override
    public Map<IPointer, List<ISynsetID>> getRelatedMap() {
        return this.synsetMap;
    }

    @Override
    public List<ISynsetID> getRelatedSynsets(IPointer type) {
        if (this.synsetMap == null) {
            return Collections.emptyList();
        }
        List<ISynsetID> result = this.synsetMap.get(type);
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public List<ISynsetID> getRelatedSynsets() {
        return this.allRelated;
    }

    @Override
    public boolean isAdjectiveSatellite() {
        return this.fIsAdjSat;
    }

    @Override
    public boolean isAdjectiveHead() {
        return this.fIsAdjHead;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fGloss == null ? 0 : this.fGloss.hashCode());
        result = 31 * result + (this.fIsAdjSat ? 1231 : 1237);
        result = 31 * result + this.fID.hashCode();
        result = 31 * result + ((Object)this.fWords).hashCode();
        result = 31 * result + ((Object)this.synsetMap).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ISynset)) {
            return false;
        }
        ISynset other = (ISynset)obj;
        if (this.fGloss == null ? other.getGloss() != null : !this.fGloss.equals(other.getGloss())) {
            return false;
        }
        if (!this.fID.equals(other.getID())) {
            return false;
        }
        if (!((Object)this.fWords).equals(other.getWords())) {
            return false;
        }
        if (this.fIsAdjSat != other.isAdjectiveSatellite()) {
            return false;
        }
        return ((Object)this.synsetMap).equals(other.getRelatedMap());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SYNSET{");
        buffer.append(this.fID.toString());
        buffer.append(" : Words[");
        for (IWord word : this.fWords) {
            buffer.append(word.toString());
            buffer.append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), "]}");
        return buffer.toString();
    }

    @Override
    public ILexFile getLexicalFile() {
        return this.fLexFile;
    }

    public static String zeroFillOffset(int offset) {
        Synset.checkOffset(offset);
        StringBuilder sb = new StringBuilder(8);
        String offsetStr = Integer.toString(offset);
        int numZeros = 8 - offsetStr.length();
        for (int i = 0; i < numZeros; ++i) {
            sb.append(zero);
        }
        sb.append(offsetStr);
        return sb.toString();
    }

    public static void checkOffset(int offset) {
        if (Synset.isIllegalOffset(offset)) {
            throw new IllegalArgumentException("'" + offset + "' is not a valid offset; offsets must be in the closed range [0,99999999]");
        }
    }

    public static boolean isIllegalOffset(int offset) {
        return offset < 0 || 99999999 < offset;
    }
}

