/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.browser.embedded.IBrowserCloseListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class EmbeddedBrowser {
    private static final String BROWSER_X = "browser.x";
    private static final String BROWSER_Y = "browser.y";
    private static final String BROWSER_WIDTH = "browser.w";
    private static final String BROWSER_HEIGTH = "browser.h";
    private static final String BROWSER_MAXIMIZED = "browser.maximized";
    private Preferences store;
    private static String initialTitle = EmbeddedBrowser.getWindowTitle();
    private Shell shell;
    private Browser browser;
    private Browser externalBrowser;
    private Composite statusBar;
    private Label statusBarText;
    private Label statusBarSeparator;
    private ProgressBar statusBarProgress;
    private String statusText;
    private int x;
    private int y;
    private int w;
    private int h;
    private long modalRequestTime = 0L;
    private Vector closeListeners = new Vector(1);

    public EmbeddedBrowser() {
        this.store = HelpUIPlugin.getDefault().getPluginPreferences();
        int style = 1264;
        style = BaseHelpSystem.isRTL() ? (style |= 0x4000000) : (style |= 0x2000000);
        this.shell = new Shell(style);
        EmbeddedBrowser.initializeShell(this.shell);
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = location.x;
                    EmbeddedBrowser.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = size.x;
                    EmbeddedBrowser.this.h = size.y;
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_X, Integer.toString(EmbeddedBrowser.this.x));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_Y, Integer.toString(EmbeddedBrowser.this.y));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_WIDTH, Integer.toString(EmbeddedBrowser.this.w));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_HEIGTH, Integer.toString(EmbeddedBrowser.this.h));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_MAXIMIZED, new Boolean(EmbeddedBrowser.this.shell.getMaximized()).toString());
                EmbeddedBrowser.this.notifyCloseListners();
            }
        });
        this.browser = new Browser((Composite)this.shell, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initialize(this.browser);
        this.createStatusBar((Composite)this.shell);
        this.initializeStatusBar(this.browser);
        this.x = this.store.getInt(BROWSER_X);
        this.y = this.store.getInt(BROWSER_Y);
        this.w = this.store.getInt(BROWSER_WIDTH);
        this.h = this.store.getInt(BROWSER_HEIGTH);
        if (this.w == 0 || this.h == 0) {
            this.w = 1024;
            this.h = 768;
            this.x = this.shell.getLocation().x;
            this.y = this.shell.getLocation().y;
        }
        EmbeddedBrowser.setSafeBounds(this.shell, this.x, this.y, this.w, this.h);
        if (this.store.getBoolean(BROWSER_MAXIMIZED)) {
            this.shell.setMaximized(true);
        }
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = location.x;
                    EmbeddedBrowser.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = size.x;
                    EmbeddedBrowser.this.h = size.y;
                }
            }
        });
        this.shell.open();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (e.location != null && e.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
                if (!e.doit && e.location != null && e.location.startsWith("https://")) {
                    try {
                        BaseHelpSystem.getHelpBrowser((boolean)true).displayURL(e.location);
                    }
                    catch (Exception exception) {}
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    public EmbeddedBrowser(WindowEvent event, Shell parent) {
        if (parent == null) {
            int style = 1264;
            style = BaseHelpSystem.isRTL() ? (style |= 0x4000000) : (style |= 0x2000000);
            this.shell = new Shell(style);
        } else {
            this.shell = new Shell(parent, 34928);
        }
        EmbeddedBrowser.initializeShell(this.shell);
        Browser browser = new Browser((Composite)this.shell, 0);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initialize(browser);
        event.browser = browser;
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (e.location != null && e.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    private static void initializeShell(Shell s) {
        s.setText(initialTitle);
        Image[] shellImages = EmbeddedBrowser.createImages();
        if (shellImages != null) {
            s.setImages(shellImages);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        s.setLayout((Layout)layout);
    }

    private void initialize(Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (System.currentTimeMillis() - EmbeddedBrowser.this.modalRequestTime <= 1000L) {
                    new EmbeddedBrowser(event, EmbeddedBrowser.this.shell);
                } else if (event.required) {
                    new EmbeddedBrowser(event, null);
                } else {
                    EmbeddedBrowser.this.displayURLExternal(event);
                }
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (event.title != null && event.title.length() > 0) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.setText(event.title);
                }
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                if (!e.doit && e.location != null && e.location.startsWith("https://")) {
                    try {
                        BaseHelpSystem.getHelpBrowser((boolean)true).displayURL(e.location);
                    }
                    catch (Exception exception) {}
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    private void initializeStatusBar(Browser browser) {
        browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                if (!event.text.equals(EmbeddedBrowser.this.statusText)) {
                    EmbeddedBrowser.this.statusText = event.text;
                    EmbeddedBrowser.this.statusBarText.setText(EmbeddedBrowser.this.statusText);
                }
            }
        });
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total > 0) {
                    EmbeddedBrowser.this.statusBarProgress.setMaximum(event.total);
                    EmbeddedBrowser.this.statusBarProgress.setSelection(Math.min(event.current, event.total));
                    EmbeddedBrowser.this.statusBarSeparator.setVisible(true);
                    EmbeddedBrowser.this.statusBarProgress.setVisible(true);
                }
            }

            public void completed(ProgressEvent event) {
                EmbeddedBrowser.this.statusBarSeparator.setVisible(false);
                EmbeddedBrowser.this.statusBarProgress.setVisible(false);
            }
        });
    }

    private void createStatusBar(Composite parent) {
        this.statusBar = new Composite(parent, 0);
        this.statusBar.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginBottom = 5;
        this.statusBar.setLayout((Layout)layout);
        this.statusBarText = new Label(this.statusBar, 0);
        this.statusBarText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusBarSeparator = new Label(this.statusBar, 514);
        this.statusBarSeparator.setVisible(false);
        this.statusBarProgress = new ProgressBar(this.statusBar, 256);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 100;
        this.statusBarProgress.setLayoutData((Object)data);
        this.statusBarProgress.setVisible(false);
        this.statusBarProgress.setMinimum(0);
        data = new GridData(4, 0x1000000, false, false);
        data.heightHint = Math.max(this.statusBarText.computeSize((int)-1, (int)-1).y, this.statusBarProgress.computeSize((int)-1, (int)-1).y);
        this.statusBarSeparator.setLayoutData((Object)data);
    }

    public void displayUrl(String url) {
        this.browser.setUrl(url);
        this.shell.setMinimized(false);
        this.shell.forceActive();
    }

    private void displayURLExternal(WindowEvent e) {
        if (this.externalBrowser == null) {
            Shell externalShell = new Shell(this.shell, 0);
            this.externalBrowser = new Browser((Composite)externalShell, 0);
            this.externalBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent e) {
                    e.doit = false;
                    try {
                        BaseHelpSystem.getHelpBrowser((boolean)true).displayURL(e.location);
                    }
                    catch (Throwable t) {
                        String msg = "Error opening external Web browser";
                        HelpUIPlugin.logError(msg, t);
                    }
                }
            });
        }
        e.browser = this.externalBrowser;
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    private static String getWindowTitle() {
        if ("true".equalsIgnoreCase(HelpBasePlugin.getDefault().getPluginPreferences().getString("windowTitlePrefix"))) {
            return NLS.bind((String)Messages.browserTitle, (Object)BaseHelpSystem.getProductName());
        }
        return BaseHelpSystem.getProductName();
    }

    private static Image[] createImages() {
        String[] productImageURLs = EmbeddedBrowser.getProductImageURLs();
        if (productImageURLs != null) {
            ArrayList<Image> shellImgs = new ArrayList<Image>();
            int i = 0;
            while (i < productImageURLs.length) {
                if (!"".equals(productImageURLs[i])) {
                    URL imageURL;
                    block7: {
                        imageURL = null;
                        try {
                            imageURL = new URL(productImageURLs[i]);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Bundle productBundle;
                            IProduct product = Platform.getProduct();
                            if (product == null || (productBundle = product.getDefiningBundle()) == null) break block7;
                            imageURL = FileLocator.find((Bundle)productBundle, (IPath)new Path(productImageURLs[i]), null);
                        }
                    }
                    Image image = null;
                    if (imageURL != null) {
                        image = ImageDescriptor.createFromURL((URL)imageURL).createImage();
                    }
                    if (image != null) {
                        shellImgs.add(image);
                    }
                }
                ++i;
            }
            return shellImgs.toArray(new Image[shellImgs.size()]);
        }
        return new Image[0];
    }

    private static String[] getProductImageURLs() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String url = product.getProperty("windowImages");
            if (url != null && url.length() > 0) {
                return url.split(",\\s*");
            }
            url = product.getProperty("windowImage");
            if (url != null && url.length() > 0) {
                return new String[]{url};
            }
        }
        return null;
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private static void setSafeBounds(Shell s, int x, int y, int width, int height) {
        Rectangle clientArea = s.getDisplay().getClientArea();
        width = Math.min(clientArea.width, width);
        height = Math.min(clientArea.height, height);
        x = Math.min(x + width, clientArea.x + clientArea.width) - width;
        y = Math.min(y + height, clientArea.y + clientArea.height) - height;
        x = Math.max(x, clientArea.x);
        y = Math.max(y, clientArea.y);
        s.setBounds(x, y, width, height);
    }

    public void setLocation(int x, int y) {
        this.shell.setLocation(x, y);
    }

    public void setSize(int width, int height) {
        this.shell.setSize(this.w, this.h);
    }

    private void notifyCloseListners() {
        Iterator it = this.closeListeners.iterator();
        while (it.hasNext()) {
            IBrowserCloseListener listener = (IBrowserCloseListener)it.next();
            listener.browserClosed();
        }
    }

    public void addCloseListener(IBrowserCloseListener listener) {
        if (!this.closeListeners.contains(listener)) {
            this.closeListeners.add(listener);
        }
    }

    public void removeCloseListener(IBrowserCloseListener listener) {
        this.closeListeners.remove(listener);
    }
}

