/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.meta.merge;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.MetaRep;
import edu.mit.story.core.meta.merge.IMerged;
import edu.mit.story.core.meta.merge.Merged;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeMetaRep
extends MetaRep<IMerged> {
    public static final String ID = "edu.mit.story.meta.merge";
    private static final SortedSet<String> emptySortedSet = Collections.unmodifiableSortedSet(new TreeSet());

    public static MergeMetaRep getInstance() {
        return (MergeMetaRep)StoryPlugin.getDefault().getMetaRepManager().getMetaRep(ID);
    }

    public MergeMetaRep() {
        super(IMerged.class, false);
    }

    @Override
    public IMerged reconstitute(String description) {
        return new Merged(description);
    }

    @Override
    public String serialize(IMerged data) {
        return data.getSource();
    }

    public static SortedSet<String> extractMergeProfile(IDesc d) {
        IMetaDataSet<IMerged> mergeData = d.getMetaData().get(MergeMetaRep.getInstance());
        if (mergeData.isEmpty()) {
            return emptySortedSet;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (IMetaDesc iMetaDesc : mergeData) {
            result.add(((IMerged)iMetaDesc.getData()).getSource());
        }
        return result;
    }

    public static boolean matches(IDesc d, Collection<String> sources) {
        SortedSet<String> profile = MergeMetaRep.extractMergeProfile(d);
        return profile.isEmpty() ? true : profile.containsAll(sources);
    }

    public static boolean matches(Collection<? extends Collection<String>> sourceSets, IDesc d) {
        for (Collection<String> collection : sourceSets) {
            if (!MergeMetaRep.matches(d, collection)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(IDesc target, IDesc profileDefiningDesc) {
        return MergeMetaRep.matches(profileDefiningDesc, MergeMetaRep.extractMergeProfile(target));
    }
}

