/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.parse;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.TreeTranslator;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;

public class ParseRep
extends AbstractRep {
    private static IRep instance = null;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep("edu.mit.parsing.parse");
        }
        return instance;
    }

    public ParseRep() {
        super(ITree.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
        container.add((Object)SentenceRep.getInstance());
        container.add((Object)POSRep.getInstance());
    }

    public String serialize(IData data) {
        ITree tree = (ITree)data;
        return TreeTranslator.getInstance().toString(tree);
    }

    public ITree reconstitute(IHasPosition p, String description, IStoryModel provider) {
        return TreeTranslator.getInstance().fromString(description, provider.getData().getDescriptions(TokenRep.getInstance()));
    }
}

