/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.PosTag;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;

public class POSRep
extends AbstractRep {
    public static final String ID = "edu.mit.parsing.pos";
    public static final String AUX_POSTFIX = "(aux)";
    private static final long serialVersionUID = 2L;
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return fInstance;
    }

    public POSRep() {
        super(IPosTag.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
        container.add((Object)CollocRep.getInstance());
        container.add((Object)SentenceRep.getInstance());
    }

    public String serialize(IData data) {
        IPosTag postag = (IPosTag)data;
        StringBuilder result = new StringBuilder();
        result.append(postag.getWord().getID());
        result.append(' ');
        result.append(postag.getTag().getTagString());
        if (postag.isAuxiliary()) {
            result.append(AUX_POSTFIX);
        }
        return result.toString();
    }

    public PosTag reconstitute(IHasPosition p, String data, IStoryModel model) {
        int idx = data.indexOf(32);
        if (idx == -1) {
            return this.legacyReconstitute(p, data, model);
        }
        long id = Long.parseLong(data.substring(0, idx));
        boolean isAux = data.endsWith(AUX_POSTFIX);
        int end = data.length() - (isAux ? AUX_POSTFIX.length() : 0);
        PennTag tag = PennTag.getTag(data.substring(idx + 1, end));
        if (tag == null) {
            return null;
        }
        IDesc word = model.getData().getDescription(id);
        return new PosTag(word, tag, isAux);
    }

    public PosTag legacyReconstitute(IHasPosition p, String data, IStoryModel model) {
        boolean isAux = data.endsWith(AUX_POSTFIX);
        String tagStr = isAux ? data.substring(0, data.length() - AUX_POSTFIX.length()) : data;
        PennTag tag = PennTag.getTag(tagStr);
        if (tag == null) {
            return null;
        }
        IDesc token = null;
        IDescSet descs = model.getData().getDescriptions(TokenRep.getInstance()).matchSet(p);
        if (descs.isEmpty()) {
            descs = model.getData().getDescriptions(CollocRep.getInstance()).matchSet(p);
        }
        if (descs.size() == 1) {
            token = (IDesc)descs.first();
        }
        if (token == null) {
            return null;
        }
        return new PosTag(token, tag, isAux);
    }
}

