/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos;

import edu.mit.parsing.core.rep.pos.GenericTag;
import edu.mit.parsing.core.rep.pos.ITag;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PennTag implements ITag
{
    CC("CC", "Coordinating conjuction", "and, but", GenericTag.FUNCTION),
    CD("CD", "Cardinal number", "1, one", GenericTag.SYMBOL),
    DT("DT", "Determiner", "the, a, an", GenericTag.FUNCTION),
    EX("EX", "Existential there", "[There] is", GenericTag.FUNCTION),
    FW("FW", "Foreign word", GenericTag.TOKEN),
    IN("IN", "Preposition/subordinating conjunction", GenericTag.FUNCTION),
    JJ("JJ", "Adjective", "small, big", GenericTag.ADJECTIVE),
    JJR("JJR", "Comparative adjective", "smaller, bigger", GenericTag.ADJECTIVE),
    JJS("JJS", "Superlative adjective", "smallest, biggest", GenericTag.ADJECTIVE),
    LS("LS", "List item", "List item marker", GenericTag.SYMBOL),
    MD("MD", "Modal", "would, could, should, have", GenericTag.FUNCTION),
    NN("NN", "Singular or mass noun", GenericTag.NOUN),
    NNS("NNS", "Plural noun", GenericTag.NOUN),
    NNP("NNP", "Singular proper noun", GenericTag.PROPER_NOUN),
    NNPS("NNPS", "Plural proper noun", GenericTag.PROPER_NOUN),
    PDT("PDT", "Predeterminer", "all, both, half, many, quite, such, sure, this", GenericTag.FUNCTION),
    POS("POS", "Possessive ending", "'s", GenericTag.FUNCTION),
    PRP("PRP", "Personal pronoun", "he, she, it", GenericTag.FUNCTION),
    PRP$("PRP$", "Possessive pronoun", "his, hers, its", GenericTag.FUNCTION),
    RB("RB", "Adverb", "quickly, well", GenericTag.ADVERB),
    RBR("RBR", "Comparative adverb", "more quickly, better", GenericTag.ADVERB),
    RBS("RBS", "Superlative adverb", "most quickly, best", GenericTag.ADVERB),
    RP("RP", "Particle", "move [up]", GenericTag.FUNCTION),
    SYM("SYM", "Symbol", "Symbol (mathematical or scientific)", GenericTag.SYMBOL),
    TO("TO", "to-word", "[to] eat, [to] love", GenericTag.FUNCTION),
    UH("UH", "Interjection", "amen, huh, howdy, dammit, shucks, anyways, honey, baby", GenericTag.FUNCTION),
    VB("VB", "Base form verb", "talk, hire, eat", GenericTag.VERB),
    VBD("VBD", "Past tense verb", "talked, hired, ate", GenericTag.VERB),
    VBG("VBG", "Gerund/present participle verb", "talking, hiring, eating", GenericTag.VERB),
    VBN("VBN", "Past participle verb", "talked, hired, eaten", GenericTag.VERB),
    VBP("VBP", "Non-3rd person singular present verb", "I use, you speak", GenericTag.VERB),
    VBZ("VBZ", "3rd person singular present verb", "He uses, she speaks", GenericTag.VERB),
    WDT("WDT", "Wh-determiner", "that, what, whatever, which, whichever", GenericTag.FUNCTION),
    WP("WP", "Wh-pronoun", "that, what, whatever, which, whatsoever, who, whom, whosoever", GenericTag.FUNCTION),
    WP$("WP$", "Possessive wh-pronoun", "whose", GenericTag.FUNCTION),
    WRB("WRB", "Wh-adverb", "how, however, whence, whenever, where, whereby, whereever, wherein, whereof, why", GenericTag.FUNCTION),
    POUND("#", "Pound sign", GenericTag.SYMBOL),
    DOLLAR("$", "Dollar sign", GenericTag.SYMBOL),
    PERIOD(".", "Period", "Sentence-final punctuation", GenericTag.SYMBOL),
    COMMA(",", "Comma", GenericTag.SYMBOL),
    COLON(":", "Colon or semi-colon", GenericTag.SYMBOL),
    BRACKET_LEFT("(", "Left parens", "Left bracket character", GenericTag.SYMBOL),
    BRACKET_RIGHT(")", "Right parens", "Right bracket character", GenericTag.SYMBOL),
    QUOTE_DOUBLE_STRAIGHT("\"", "Straight double quote", GenericTag.SYMBOL),
    QUOTE_SINGLE_LEFT("`", "Left single quote", "Left open single quote", GenericTag.SYMBOL),
    QUOTE_DOUBLE_LEFT("``", "Left double quote", "Left open double quote", GenericTag.SYMBOL),
    QUOTE_SINGLE_RIGHT("'", "Right single quote", "Right close single quote", GenericTag.SYMBOL),
    QUOTE_DOUBLE_RIGHT("''", "Right double quote", "Right close double quote", GenericTag.SYMBOL),
    ADJP("ADJP", "Adjective phrase", GenericTag.PHRASAL),
    ADVP("ADVP", "Adverb phrase", GenericTag.PHRASAL),
    NP("NP", "Noun phrase", GenericTag.PHRASAL),
    PP("PP", "Prepositional phrase", GenericTag.PHRASAL),
    S("S", "Simple declarative clause", GenericTag.PHRASAL),
    SBAR("SBAR", "S-Bar", "Clause introduced by subordinating conjuction or 0", GenericTag.PHRASAL),
    SBARQ("SBARQ", "S-Bar Question", "Direct question introduced by wh-word or wh-phrase", GenericTag.PHRASAL),
    SINV("SINV", "S-Inv", "Declaritive sentence with subject-aux inversion", GenericTag.PHRASAL),
    SQ("SQ", "SBARQ Subconsituent", "Subconstituent of SBARQ excluding wh-word or wh-phrase", GenericTag.PHRASAL),
    VP("VP", "Verb phrase", GenericTag.PHRASAL),
    WHADVP("WHADVP", "Wh-adverb phrase", GenericTag.PHRASAL),
    WHNP("WHNP", "Wh-noun phrase", GenericTag.PHRASAL),
    WHPP("WHPP", "Wh-prepositional phrase", GenericTag.PHRASAL),
    UNKNOWN("X", "Unknown", "Consituent of unknown or uncertain category", GenericTag.PHRASAL),
    STAR("*", "Understood subject", "`Understood' subject of infinitive or imperative", GenericTag.PHRASAL),
    ZERO("0", "Zero variant", "Zero variant of that in subordinate clauses", GenericTag.PHRASAL),
    TRACE("T", "Trace", "Trace--marks position where moved wh-consituent is interpreted", GenericTag.PHRASAL),
    NIL("NIL", "Interpreted preposition location", "Marks position where preposition is interpreted in pied-piping contexts", GenericTag.PHRASAL);

    private final String fTag;
    private final String fName;
    private final String fDesc;
    private final GenericTag fGeneric;
    static final Map<String, PennTag> tagMap;

    static {
        TreeMap<String, PennTag> hidden = new TreeMap<String, PennTag>();
        PennTag[] pennTagArray = PennTag.values();
        int n = pennTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PennTag t = pennTagArray[n2];
            hidden.put(t.getTagString(), t);
            ++n2;
        }
        tagMap = Collections.unmodifiableMap(hidden);
    }

    public static PennTag getTag(String tag) {
        return tagMap.get(tag);
    }

    private PennTag(String tag, String name, GenericTag generic) {
        this(tag, name, name, generic);
    }

    private PennTag(String tag, String name, String description, GenericTag generic) {
        this.fTag = tag;
        this.fName = name;
        this.fDesc = description;
        this.fGeneric = generic;
    }

    public String getName() {
        return this.fName;
    }

    @Override
    public String getTagString() {
        return this.fTag;
    }

    public String getDescription() {
        return this.fDesc;
    }

    public String toString() {
        return this.fName;
    }

    @Override
    public boolean isAdjective() {
        return this.fGeneric.isAdjective();
    }

    @Override
    public boolean isAdverb() {
        return this.fGeneric.isAdverb();
    }

    @Override
    public boolean isNoun() {
        return this.fGeneric.isNoun();
    }

    @Override
    public boolean isOpenClass() {
        return this.fGeneric.isOpenClass();
    }

    @Override
    public boolean isProperNoun() {
        return this.fGeneric.isProperNoun();
    }

    @Override
    public boolean isVerb() {
        return this.fGeneric.isVerb();
    }

    @Override
    public boolean isPhrase() {
        return this.fGeneric.isPhrase();
    }

    @Override
    public boolean isToken() {
        return this.fGeneric.isToken();
    }

    @Override
    public boolean isStemmable() {
        return this.fGeneric.isStemmable();
    }

    @Override
    public GenericTag toGenericTag() {
        return this.fGeneric;
    }
}

