/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset.models;

import com.google.common.base.Strings;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.Tag;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagDataModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IHasRep;
import java.util.Collection;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IMessageProvider;

public class TagDataModel
extends SegmentSetModel
implements ITagDataModel,
ChangeListener {
    private String tagID = this.getDefaultTagID();
    private IDesc loaded;
    public static final String UNKNOWN_TAGID = "UNKNOWN";
    public static final ITag UNKNOWN_TAG = new Tag("UNKNOWN", "Unknown", "Unknown Tag", null);

    public TagDataModel(IStoryModel storyModel) {
        super(TokenRep.getInstance(), storyModel);
        ParsingPlugin.getDefault().getTagsetManager().addChangeListener(this);
    }

    public void dispose() {
        ParsingPlugin.getDefault().getTagsetManager().removeChangeListener(this);
        super.dispose();
    }

    protected void internalClear() {
        this.loaded = null;
        this.tagID = this.getDefaultTagID();
        super.internalClear();
    }

    protected IMessageProvider calculateMessage() {
        return super.calculateMessage();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (!this.getDefaultTagID().equals(this.tagID)) {
            return false;
        }
        return super.isCleared();
    }

    public ITag getTag() {
        ITagset tagset = this.getTagset();
        ITag tag = null;
        if (tagset != null) {
            tag = tagset.getTag(this.tagID);
        }
        if (tag == null) {
            tag = new Tag(this.tagID, "Unknown", "Unknown Tag", null);
        }
        return tag;
    }

    public ITagset getTagset() {
        return TagRep.getTagset(this.getStoryModel());
    }

    public String getTagID() {
        return this.tagID;
    }

    public void setTagID(String tagID) {
        this.tagID = Strings.nullToEmpty((String)tagID).trim();
        this.fireChanged();
    }

    protected String getDefaultTagID() {
        ITagset tagset = this.getTagset();
        return tagset == null ? UNKNOWN_TAGID : tagset.getDefault().getID();
    }

    public IDesc getLoaded() {
        return this.loaded;
    }

    public void load(IDesc desc) {
        if (!TagRep.getInstance().isType((IHasRep)desc)) {
            throw new IllegalArgumentException();
        }
        this.internalClear();
        this.loaded = desc;
        ITagData tagData = (ITagData)desc.getData();
        this.suppressNotifications();
        this.setSegments((Collection<? extends ISegment>)((Object)tagData));
        this.setTagID(tagData.getTagID());
        this.allowNotifications();
    }

    public ITagData create() {
        return new TagData(this.getTagID(), (Collection<? extends ISegment>)this.getSegments());
    }

    public void stateChanged(ChangeEvent e) {
        ITagset current;
        IFile file = (IFile)e.getSource();
        ITagset changed = ParsingPlugin.getDefault().getTagsetManager().createByPath(file.getFullPath().toPortableString());
        if (changed == (current = TagRep.getTagset(this.getStoryModel()))) {
            if (this.isCleared()) {
                this.clear();
            } else {
                this.fireChanged();
            }
        }
    }
}

