/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;

public class TimeLink
implements ITimeLink {
    private final IRelType type;
    private final IDesc source;
    private final IDesc related;
    private final ISegment signal;
    private IHasPosition pos;
    private IHasPosition display;

    public TimeLink(IRelType type, IDesc source, IDesc related, ISegment signal) {
        if (!type.getType().isAppropriateArgument(source)) {
            throw new IllegalArgumentException();
        }
        if (!type.getType().isAppropriateArgument(related)) {
            throw new IllegalArgumentException();
        }
        if (signal != null && !TokenRep.getInstance().isType((IHasRep)signal)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.source = source;
        this.related = related;
        this.signal = signal;
    }

    public IRelType getRelationType() {
        return this.type;
    }

    public IDesc getSource() {
        return this.source;
    }

    public IDesc getRelated() {
        return this.related;
    }

    public ISegment getSignal() {
        return this.signal;
    }

    public IHasPosition calculatePosition() {
        if (this.pos == null) {
            this.pos = this.signal == null ? PositionUtils.combineAll((IHasPosition[])new IHasPosition[]{this.source, this.related}) : PositionUtils.combineAll((IHasPosition[])new IHasPosition[]{this.source, this.related, this.signal});
        }
        return this.pos;
    }

    public IHasPosition getDisplayPosition() {
        if (this.display == null) {
            this.display = this.signal == null ? this.calculatePosition() : new SimplePosition((IHasPosition)this.signal);
        }
        return this.calculatePosition();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        ISegment newSignal;
        IDesc newSource = model.getData().getDescription(this.source.getID());
        IDesc newRelated = model.getData().getDescription(this.related.getID());
        ISegment iSegment = newSignal = this.signal == null ? null : (ISegment)this.signal.recalculate(container, model);
        if (newSource == null) {
            return null;
        }
        if (newRelated == null) {
            return null;
        }
        if (this.signal != null && newSignal == null) {
            return null;
        }
        boolean same = true;
        same &= this.source == newSource;
        same &= this.related == newRelated;
        return (same &= this.signal == newSignal) ? this : new TimeLink(this.type, newSource, newRelated, newSignal);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (!ITimeLink.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ITimeLink tgtLink = (ITimeLink)tgtData;
        if (!this.type.equals(tgtLink.getRelationType())) {
            return false;
        }
        if (!this.source.equals(tgtLink.getSource(), model)) {
            return false;
        }
        if (!this.related.equals(tgtLink.getRelated(), model)) {
            return false;
        }
        return Data.equals((IData)this.signal, (IData)tgtLink.getSignal(), (IAlignedStoryModel)model);
    }
}

