/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.problems;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collections;

public class NoTemporalLinkProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.timelink.problem.noTemporalLink";

    public NoTemporalLinkProblem(IDesc desc, String buildRuleID) {
        super(TimeLinkRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("no temporal link");
        this.setSeverity(2);
        this.setDescs(Collections.singleton(desc));
        this.setCheck(ID);
        IDescSet es = this.getDescs().getDescriptions(EventRep.getInstance());
        IDescSet ts = this.getDescs().getDescriptions(Timex3Rep.getInstance());
        if (es.isEmpty() && ts.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        if (es.isEmpty()) {
            this.setPosition((IHasPosition)ts.first());
            ITimex3 time = (ITimex3)((IDesc)ts.first()).getData();
            sb.append("The time '");
            sb.append(time.getExpression().getDisplayText());
        } else {
            this.setPosition((IHasPosition)es.first());
            IEvent event = (IEvent)((IDesc)es.first()).getData();
            sb.append("The event '");
            sb.append(event.getEventTokens().getDisplayText());
        }
        sb.append("' is not involved in a temporal or aspectual link");
        this.setDescription(sb.toString());
    }
}

