/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.mappers.RepresentationValueMapper;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.ui.AbstractIconPlugin;
import edu.mit.story.ui.build.ContextBuildRuleManager;
import edu.mit.story.ui.build.IContextBuildRuleManager;
import edu.mit.story.ui.document.StoryPartitionScanner;
import edu.mit.story.ui.editor.IStoryTextHoverManager;
import edu.mit.story.ui.editor.StoryTextHoverManager;
import edu.mit.story.ui.helpers.CreatorPageManager;
import edu.mit.story.ui.helpers.DetailsPageManager;
import edu.mit.story.ui.helpers.ICreatorPageManager;
import edu.mit.story.ui.helpers.IDetailsPageManager;
import edu.mit.story.ui.util.ColorManager;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.swt.graphics.Device;
import org.osgi.framework.BundleContext;

public class StoryUIPlugin
extends AbstractIconPlugin {
    public static final String ID = "edu.mit.story.ui";
    private static StoryUIPlugin plugin;
    private ColorManager colorManager;
    private IPartitionTokenScanner scanner;
    private ICreatorPageManager creatorManager;
    private IDetailsPageManager detailsManager;
    private IContextBuildRuleManager ruleManager;
    private IStoryTextHoverManager hoverManager;
    IValueMapper<IRep> fMapper = new RepresentationValueMapper(StoryPlugin.getDefault().getRepManager());

    public static StoryUIPlugin getDefault() {
        return plugin;
    }

    public StoryUIPlugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.colorManager != null) {
            this.colorManager.dispose();
        }
        this.colorManager = null;
        this.creatorManager = null;
        this.detailsManager = null;
        this.scanner = null;
        plugin = null;
        super.stop(context);
    }

    public IPartitionTokenScanner getStoryPartitionScanner() {
        if (this.scanner == null) {
            this.scanner = new StoryPartitionScanner();
        }
        return this.scanner;
    }

    public ICreatorPageManager getCreatorPageManager() {
        if (this.creatorManager == null) {
            this.creatorManager = new CreatorPageManager();
            this.creatorManager.init();
        }
        return this.creatorManager;
    }

    public IStoryTextHoverManager getStoryTextHoverManager() {
        if (this.hoverManager == null) {
            this.hoverManager = new StoryTextHoverManager();
            this.hoverManager.init();
        }
        return this.hoverManager;
    }

    public IDetailsPageManager getDetailPageManager() {
        if (this.detailsManager == null) {
            this.detailsManager = new DetailsPageManager();
            this.detailsManager.init();
        }
        return this.detailsManager;
    }

    public ColorManager getColorManager() {
        if (this.colorManager == null) {
            this.colorManager = new ColorManager((Device)this.getWorkbench().getDisplay());
        }
        return this.colorManager;
    }

    public IRepSet getDefaultReps() {
        List reps;
        RepSet result = new RepSet();
        IPreferenceStore fStore = this.getPreferenceStore();
        String value = fStore.getString("DefaultRepresentations");
        if (value.length() == 0) {
            value = fStore.getDefaultString("DefaultRepresentations");
        }
        if (value.length() != 0 && (reps = this.fMapper.reconstitute(value)) != null) {
            result.addAll((Collection)reps);
        }
        return result;
    }

    public IContextBuildRuleManager getBuildRuleManager() {
        if (this.ruleManager == null) {
            this.ruleManager = new ContextBuildRuleManager();
            this.ruleManager.init();
        }
        return this.ruleManager;
    }
}

