/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.handlers;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.IMetaRepManager;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteMetadataHandler
extends AbstractHandler {
    public static final String paramID = "edu.mit.story.ui.commands.deleteMetadata.rep";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String name;
        IStoryEditor editor;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IStoryEditor iStoryEditor = editor = part instanceof IStoryEditor ? (IStoryEditor)part : null;
        if (editor == null) {
            return null;
        }
        String metarepID = event.getParameter(paramID);
        IMetaRep metarep = null;
        if (metarepID != null && (metarep = (IMetaRep)StoryPlugin.getDefault().getMetaRepManager().getDescriptor(metarepID)) == null) {
            throw new IllegalArgumentException();
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        boolean result = MessageDialog.openConfirm((Shell)shell, (String)("Delete " + (name = metarep == null ? "all" : metarep.getName()) + " Metadata"), (String)("Press OK to delete " + name + " metadata on this file"));
        if (result) {
            RemoveMetadataChange change = metarep == null ? new RemoveMetadataChange() : new RemoveMetadataChange(metarep);
            editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }
        return null;
    }

    public static class DeleteMetadataParamValues
    implements IParameterValues {
        public Map getParameterValues() {
            IMetaRepManager manager = StoryPlugin.getDefault().getMetaRepManager();
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (IMetaRep d : manager.getDescriptors()) {
                result.put(d.getName(), d.getID());
            }
            return result;
        }
    }
}

