/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.validation;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.widgets.FilteredContainerSelectionGroup;
import edu.mit.story.ui.widgets.InputFilenameGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.osgi.util.NLS;

public class FullPathValidationLogic
extends ChangeNotifier
implements INotifyingMessageProvider,
ChangeListener {
    protected boolean outOfSync = true;
    protected IMessageProvider message = Message.NO_MESSAGE;
    private final InputFilenameGroup filenameGroup;
    private final FilteredContainerSelectionGroup containerGroup;

    public FullPathValidationLogic(InputFilenameGroup filenameGroup, FilteredContainerSelectionGroup containerGroup) {
        if (filenameGroup == null) {
            throw new NullPointerException();
        }
        if (containerGroup == null) {
            throw new NullPointerException();
        }
        this.filenameGroup = filenameGroup;
        this.containerGroup = containerGroup;
        filenameGroup.addChangeListener(this);
        containerGroup.addChangeListener(this);
    }

    public String getMessage() {
        if (this.outOfSync) {
            this.message = this.calculateMessage();
            this.outOfSync = false;
        }
        return this.message.getMessage();
    }

    public int getMessageType() {
        if (this.outOfSync) {
            this.message = this.calculateMessage();
            this.outOfSync = false;
        }
        return this.message.getMessageType();
    }

    protected IMessageProvider calculateMessage() {
        String filename = this.filenameGroup.getValue();
        IPath path = this.containerGroup.getContainerFullPath().append(filename);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!workspace.validatePath(path.toString(), 2).isOK()) {
            return new Message(StoryUIMessages.MSG_InvalidPath, 3);
        }
        if (workspace.getRoot().getFolder(path).exists() || workspace.getRoot().getFile(path).exists()) {
            return new Message(NLS.bind((String)StoryUIMessages.MSG_ResourceExists, (Object)filename), 3);
        }
        return Message.NO_MESSAGE;
    }

    public void stateChanged(ChangeEvent e) {
        this.outOfSync = true;
        this.notifyChangeListeners(e);
    }
}

