/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.descriptor.IConfigurableDescriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IHasConfiguration;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.label.DescriptorLabelProvider;
import edu.mit.story.ui.validation.IConfigurationWidget;
import edu.mit.story.ui.widgets.ConfigurationWidget;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorListConfigurationWidget<D extends IDescriptor>
extends ChangeNotifier
implements IConfigurationWidget,
IHasConfiguration {
    private final String label;
    private final D desc;
    private final List<? extends IDescriptor> descList;
    private Group widgetControl;
    private ComboViewer combo;
    private Label descLabel;
    private Label configSpacer;
    private IConfigurationWidget configWidget;
    final MessageProviderManager manager = new MessageProviderManager((ChangeListener)this);

    public DescriptorListConfigurationWidget(Composite parent, String label, D desc, List<? extends IDescriptor> descList) {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (descList.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.label = label == null ? "" : label;
        this.desc = desc;
        this.descList = descList;
        this.createControl(parent);
    }

    @Override
    public void createControl(Composite parent) {
        this.widgetControl = new Group(parent, 0);
        this.widgetControl.setText(this.desc.getName());
        this.widgetControl.setLayout((Layout)new GridLayout(2, false));
        Label factLabel = new Label((Composite)this.widgetControl, 0);
        factLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        factLabel.setText(this.label);
        this.combo = new ComboViewer((Composite)this.widgetControl, 8);
        this.combo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.combo.setLabelProvider((IBaseLabelProvider)new DescriptorLabelProvider());
        this.combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.combo.setInput(this.descList);
        this.combo.getCombo().select(0);
        new Label((Composite)this.widgetControl, 0);
        this.descLabel = new Label((Composite)this.widgetControl, 64);
        this.descLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DescriptorListConfigurationWidget.this.updateWidget();
            }
        });
        this.updateWidget();
    }

    protected void updateWidget() {
        IConfigDescriptor configDesc;
        IDescriptor desc = this.getSelectedDescriptor();
        this.descLabel.setText(desc == null ? "" : desc.getDescription());
        this.widgetControl.layout(true, true);
        if (this.configSpacer != null) {
            this.configSpacer.dispose();
            this.configSpacer = null;
        }
        if (this.configWidget != null) {
            this.configWidget.getControl().dispose();
            this.manager.remove((INotifyingMessageProvider)this.configWidget);
            this.configWidget = null;
        }
        if (desc != null && desc instanceof IConfigurableDescriptor && (configDesc = ((IConfigurableDescriptor)desc).getConfigurationDescriptor()) != null) {
            this.configSpacer = new Label((Composite)this.widgetControl, 0);
            this.configWidget = new ConfigurationWidget((Composite)this.widgetControl, configDesc);
            this.configWidget.getControl().setLayoutData((Object)new GridData(4, 0, true, false));
            this.configWidget.getControl().addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DescriptorListConfigurationWidget.this.widgetControl.layout(true, true);
                }
            });
            this.manager.add((INotifyingMessageProvider)this.configWidget);
        }
        this.widgetControl.layout(true, true);
    }

    public Group getControl() {
        return this.widgetControl;
    }

    public D getDescriptor() {
        return this.desc;
    }

    public IDescriptor getSelectedDescriptor() {
        return SelectionUtils.extractSingle(this.combo.getSelection(), IDescriptor.class);
    }

    public IConfiguration getConfiguration() {
        return this.configWidget == null ? null : this.configWidget.getConfiguration();
    }

    public String getMessage() {
        return this.manager.getMessage();
    }

    public int getMessageType() {
        return this.manager.getMessageType();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.combo;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners();
    }
}

