/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.property.IModelConfiguration;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.build.StoryNature;
import edu.mit.story.ui.ops.CreateFileOperation;
import edu.mit.story.ui.ops.CreateStoryFileOperation;
import edu.mit.story.ui.wizards.page.FactoryConfigPage;
import edu.mit.story.ui.wizards.page.ImportTextPage;
import edu.mit.story.ui.wizards.page.SpecifyStoryRepsPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportStoryWizard
extends Wizard
implements IImportWizard,
INewWizard {
    IWorkbench workbench;
    IStructuredSelection selection;
    ImportTextPage importStoryPage;
    SpecifyStoryRepsPage specifyRepsPage;
    FactoryConfigPage factoryPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(StoryUIMessages.WIZARD_ImportStory_title);
        ImageDescriptor desc = StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/importstory_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.importStoryPage = new ImportTextPage();
        this.importStoryPage.setSelection((ISelection)this.selection);
        this.addPage((IWizardPage)this.importStoryPage);
        this.specifyRepsPage = new SpecifyStoryRepsPage();
        this.addPage((IWizardPage)this.specifyRepsPage);
        this.factoryPage = new FactoryConfigPage();
        this.addPage((IWizardPage)this.factoryPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next == this.specifyRepsPage) {
            this.specifyRepsPage.getController().loadProject(this.importStoryPage.getProject());
        }
        if (next == this.factoryPage || next == this.specifyRepsPage) {
            this.factoryPage.setRepresentations(this.specifyRepsPage.getController().getModel().getSupported());
        }
        return next;
    }

    public boolean performFinish() {
        ImportTextPage.ImportType type = this.importStoryPage.getSourceType();
        if (type == null) {
            return false;
        }
        IPath targetPath = this.importStoryPage.getFullPath();
        IPath sourcePath = this.importStoryPage.getSourcePath();
        StoryNature nature = StoryNature.getStoryNature(this.importStoryPage.getProject());
        CreateStoryFileOperation op = null;
        if (type == ImportTextPage.ImportType.STORY_FILE) {
            StringBuilder sb = new StringBuilder();
            StringUtils.loadStreamIntoBuffer((Appendable)sb, (InputStream)CreateFileOperation.getContent(sourcePath));
            Document xml = XMLUtils.fromString((String)sb.toString());
            Element e = null;
            NodeList list = xml.getElementsByTagName("rep");
            int i = 0;
            while (i < list.getLength()) {
                e = (Element)list.item(i);
                String id = e.getAttributeNode("id").getValue();
                if (CharRep.getInstance().getID().equals(id)) break;
                e = null;
                ++i;
            }
            if (e == null) {
                return false;
            }
            list = e.getElementsByTagName("desc");
            if (list.getLength() != 1) {
                return false;
            }
            e = (Element)list.item(0);
            String text = e.getTextContent();
            ByteArrayInputStream content = new ByteArrayInputStream(text.getBytes());
            op = new CreateStoryFileOperation(targetPath, (InputStream)content, (IModelConfiguration)nature.getProjectConfiguration());
        } else {
            op = new CreateStoryFileOperation(targetPath, sourcePath, (IModelConfiguration)nature.getProjectConfiguration());
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            LogUtils.logError((Plugin)StoryUIPlugin.getDefault(), (Throwable)e);
            return false;
        }
        WorkbenchUtils.selectAndReveal((IResource)op.getFile(), this.workbench.getActiveWorkbenchWindow());
        WorkbenchUtils.openEditor(op.getFile(), this.workbench.getActiveWorkbenchWindow());
        return true;
    }
}

