/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOptions;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.Messages;
import java.text.ParseException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.ShowHistoryAction;
import org.tigris.subversion.subclipse.ui.history.HistorySearchViewerFilter;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShowRemoteHistoryAction
extends ShowHistoryAction {
    public IStructuredSelection fSelection;

    protected ISVNRemoteResource[] getSelectedRemoteResources() {
        MergeOutput mergeOutput = null;
        ISVNRemoteFile remoteResource = null;
        for (Object object : this.fSelection) {
            MergeOptions mergeOptions;
            if (object instanceof MergeResult) {
                MergeResult mergeResult = (MergeResult)object;
                IResource resource = mergeResult.getResource();
                mergeOutput = mergeResult.getMergeOutput();
                mergeOptions = mergeOutput.getMergeOptions();
                SVNUrl svnUrl = mergeOptions.getFromUrl();
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    String resourceSubString = resource.getFullPath().toOSString().substring(mergeOutput.getTarget().length() + 1);
                    if (!resourceSubString.startsWith("/")) {
                        resourceSubString = "/" + resourceSubString;
                    }
                    SVNUrl remoteResourceUrl = new SVNUrl(String.valueOf(svnUrl.toString()) + resourceSubString.replaceAll("\\\\", "/"));
                    remoteResource = svnResource.getRepository().getRemoteFile(remoteResourceUrl);
                }
                catch (Exception e) {
                    Activator.handleError(Messages.ShowRemoteHistoryAction_error, e);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ShowRemoteHistoryAction_title, (String)e.getLocalizedMessage());
                }
                break;
            }
            if (!(object instanceof MergeResultsFolder)) continue;
            MergeResultsFolder mergeResultsFolder = (MergeResultsFolder)object;
            IContainer folder = mergeResultsFolder.getFolder();
            mergeOutput = mergeResultsFolder.getMergeOutput();
            mergeOptions = mergeOutput.getMergeOptions();
            SVNUrl svnUrl = mergeOptions.getFromUrl();
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)folder);
            try {
                String resourceSubString = folder.getFullPath().toOSString().substring(mergeOutput.getTarget().length() + 1);
                if (!resourceSubString.startsWith("/")) {
                    resourceSubString = "/" + resourceSubString;
                }
                SVNUrl remoteResourceUrl = new SVNUrl(String.valueOf(svnUrl.toString()) + resourceSubString.replaceAll("\\\\", "/"));
                remoteResource = svnResource.getRepository().getRemoteFile(remoteResourceUrl);
            }
            catch (Exception e) {
                Activator.handleError(Messages.ShowRemoteHistoryAction_error, e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ShowRemoteHistoryAction_title, (String)e.getLocalizedMessage());
            }
            break;
        }
        if (remoteResource != null) {
            ISVNRemoteResource[] selectedResource = new ISVNRemoteResource[]{remoteResource};
            SVNRevision.Number startRevision = null;
            try {
                startRevision = (SVNRevision.Number)SVNRevision.getRevision((String)Long.toString(mergeOutput.getLowerRevision()));
            }
            catch (ParseException parseException) {}
            SVNRevision.Number endRevision = null;
            if (mergeOutput.getUpperRevision() > 0L) {
                try {
                    endRevision = (SVNRevision.Number)SVNRevision.getRevision((String)Long.toString(mergeOutput.getUpperRevision()));
                }
                catch (ParseException parseException) {}
            }
            HistorySearchViewerFilter historySearchViewerFilter = new HistorySearchViewerFilter(null, null, null, null, true, startRevision, endRevision);
            SVNHistoryPage.setHistorySearchViewerFilter((HistorySearchViewerFilter)historySearchViewerFilter);
            return selectedResource;
        }
        return new ISVNRemoteResource[0];
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
        }
    }
}

